/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.annotation.handler.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.seasar.ymir.annotation.handler.AnnotationElement;
import org.seasar.ymir.annotation.handler.AnnotationElements;
import org.seasar.ymir.annotation.handler.AnnotationProcessor;
import org.seasar.ymir.annotation.handler.impl.AbstractAnnotationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionAnnotationElement
extends AbstractAnnotationElement {
    private AnnotationElement[] expandedElements_;

    public CollectionAnnotationElement(Annotation annotation) {
        super(annotation);
        this.expand(this.getAnnotation());
    }

    CollectionAnnotationElement() {
        super(null);
    }

    void expand(Annotation collectionAnnotation) {
        ArrayList<AnnotationElement> list = new ArrayList<AnnotationElement>();
        for (String name : AnnotationElements.getPropertyNames(collectionAnnotation.annotationType())) {
            Class<?> componentType;
            Object value = AnnotationElements.getPropertyValue(collectionAnnotation, name);
            Class<?> valueClass = value.getClass();
            boolean array = valueClass.isArray();
            Class<?> clazz = componentType = array ? valueClass.getComponentType() : valueClass;
            if (!Annotation.class.isAssignableFrom(componentType)) {
                throw new IllegalArgumentException("Type of '" + name + "' property must be an instance or an array of annotation: " + collectionAnnotation);
            }
            if (array) {
                for (Annotation anno : (Annotation[])value) {
                    list.add(AnnotationElements.newInstance(anno));
                }
                continue;
            }
            list.add(AnnotationElements.newInstance((Annotation)value));
        }
        this.expandedElements_ = list.toArray(new AnnotationElement[0]);
    }

    @Override
    public <R> R accept(AnnotationProcessor<?> visitor, Object ... parameters) {
        for (AnnotationElement element : this.expandedElements_) {
            Object returned = element.accept(visitor, new Object[0]);
            if (returned == null) continue;
            return returned;
        }
        return null;
    }

    AnnotationElement[] getExpandedElements() {
        return this.expandedElements_;
    }
}

