/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.util;

import java.beans.Introspector;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtils {
    private static final String PREFIX_SET = "set";
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_IS = "is";

    protected BeanUtils() {
    }

    public static String toPropertyName(String methodName) {
        return BeanUtils.toPropertyName(methodName, true);
    }

    public static String toPropertyName(String methodName, boolean strict) {
        String name = null;
        if (methodName == null) {
            return null;
        }
        if (methodName.startsWith(PREFIX_IS)) {
            name = methodName.substring(PREFIX_IS.length());
        } else if (methodName.startsWith(PREFIX_GET)) {
            name = methodName.substring(PREFIX_GET.length());
        } else if (methodName.startsWith(PREFIX_SET)) {
            name = methodName.substring(PREFIX_SET.length());
        } else if (!strict) {
            for (int i = 0; i < methodName.length(); ++i) {
                char ch = methodName.charAt(i);
                if (!Character.isUpperCase(ch)) continue;
                name = methodName.substring(i);
                break;
            }
        }
        return name != null && name.length() == 0 ? null : Introspector.decapitalize(name);
    }

    public static String getFirstSimpleSegment(String propertyName) {
        String segment = BeanUtils.getFirstSegment(propertyName);
        if (segment == null) {
            return null;
        }
        int index = segment.indexOf(91);
        if (index < 0 && (index = segment.indexOf(40)) < 0) {
            return segment;
        }
        return segment.substring(0, index);
    }

    public static String getFirstSegment(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        int dot = propertyName.indexOf(46);
        int beginMap = propertyName.indexOf(40);
        int endMap = propertyName.indexOf(41);
        if (endMap >= 0 && beginMap >= 0 && (dot < 0 || dot >= 0 && dot > beginMap)) {
            dot = propertyName.indexOf(46, endMap);
        }
        if (dot < 0) {
            return propertyName;
        }
        return propertyName.substring(0, dot);
    }

    public static boolean isSingleSegment(String propertyName) {
        return propertyName.indexOf(46) < 0;
    }

    public static boolean isAmbiguousPropertyName(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            return false;
        }
        if (propertyName.length() >= 2 && Character.isUpperCase(propertyName.charAt(1))) {
            return Character.isLowerCase(propertyName.charAt(0));
        }
        return Character.isUpperCase(propertyName.charAt(0));
    }

    public static String normalizePropertyName(String propertyName) {
        if (!BeanUtils.isAmbiguousPropertyName(propertyName)) {
            return propertyName;
        }
        if (propertyName.length() >= 2 && Character.isUpperCase(propertyName.charAt(1))) {
            return Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        }
        return Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    public static Class<?> getPropertyType(Method method) {
        if (method != null) {
            Class<?>[] types;
            String name = method.getName();
            if (name.startsWith(PREFIX_GET) || name.startsWith(PREFIX_IS)) {
                return method.getReturnType();
            }
            if (name.startsWith(PREFIX_SET) && (types = method.getParameterTypes()).length > 0) {
                return types[0];
            }
        }
        return null;
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }
}

