/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.mock;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.seasar.ymir.AttributeContainer;
import org.seasar.ymir.Dispatch;
import org.seasar.ymir.Dispatcher;
import org.seasar.ymir.FormFile;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.MatchedPathMapping;
import org.seasar.ymir.RequestWrapper;
import org.seasar.ymir.impl.RequestImpl;
import org.seasar.ymir.mock.MockMatchedPathMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockRequest
extends RequestWrapper {
    private AttributeContainer attributeContainer_ = this;
    private String contextPath_;
    private HttpMethod method_;
    private Map<String, String[]> parameterMap_ = new HashMap<String, String[]>();
    private Map<String, FormFile[]> fileParameterMap_ = new HashMap<String, FormFile[]>();
    private Locale locale_;
    private Map<String, Object> attributeMap_ = new HashMap<String, Object>();
    private MatchedPathMapping matchedPathMapping_ = new MockMatchedPathMapping();
    private Dispatch requestDispatch_;
    private Dispatch dispatch_;
    private LinkedList<Dispatch> dispatchStack_ = new LinkedList();

    public MockRequest() {
        super(new RequestImpl());
    }

    @Override
    public String getAbsolutePath() {
        if (this.requestDispatch_ != null) {
            return this.requestDispatch_.getAbsolutePath();
        }
        return null;
    }

    @Override
    public AttributeContainer getAttributeContainer() {
        return this.attributeContainer_;
    }

    @Override
    public String getContextPath() {
        return this.contextPath_;
    }

    public Dispatcher getDispatcher() {
        if (this.requestDispatch_ != null) {
            return this.requestDispatch_.getDispatcher();
        }
        return null;
    }

    public boolean isMatched() {
        return this.matchedPathMapping_ != null;
    }

    public boolean isDenied() {
        return this.matchedPathMapping_ == null || this.matchedPathMapping_.isDenied();
    }

    @Override
    public HttpMethod getMethod() {
        return this.method_;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.parameterMap_;
    }

    public MockRequest setParameter(String name, String value) {
        this.getParameterMap().put(name, new String[]{value});
        return this;
    }

    public MockRequest setParameterValues(String name, String[] values) {
        this.getParameterMap().put(name, values);
        return this;
    }

    @Override
    public String getPath() {
        if (this.requestDispatch_ != null) {
            return this.requestDispatch_.getPath();
        }
        return null;
    }

    public String getPathInfo() {
        if (this.requestDispatch_ != null) {
            return this.requestDispatch_.getPathInfo();
        }
        return null;
    }

    public MockRequest setAttributeContainer(AttributeContainer attributeContainer) {
        this.attributeContainer_ = attributeContainer;
        return this;
    }

    public MockRequest setContextPath(String contextPath) {
        this.contextPath_ = contextPath;
        return this;
    }

    public MockRequest setMethod(HttpMethod method) {
        this.method_ = method;
        return this;
    }

    public MockRequest setParameterMap(Map<String, String[]> parameterMap) {
        this.parameterMap_ = parameterMap;
        return this;
    }

    public MockRequest setFileParameterMap(Map<String, FormFile[]> fileParameterMap) {
        this.fileParameterMap_ = fileParameterMap;
        return this;
    }

    public MockRequest setFileParameter(String name, FormFile value) {
        this.getFileParameterMap().put(name, new FormFile[]{value});
        return this;
    }

    public MockRequest setFileParameterValues(String name, FormFile[] values) {
        this.getFileParameterMap().put(name, values);
        return this;
    }

    @Override
    public FormFile getFileParameter(String name) {
        FormFile[] values = this.getFileParameterValues(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    @Override
    public Map<String, FormFile[]> getFileParameterMap() {
        return this.fileParameterMap_;
    }

    @Override
    public Iterator<String> getFileParameterNames() {
        return this.getFileParameterMap().keySet().iterator();
    }

    @Override
    public FormFile[] getFileParameterValues(String name) {
        return this.getFileParameterMap().get(name);
    }

    @Override
    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    @Override
    public String getParameter(String name, String defaultValue) {
        String value = this.getParameter(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public Iterator<String> getParameterNames() {
        return this.getParameterMap().keySet().iterator();
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    @Override
    public String[] getParameterValues(String name, String[] defaultValues) {
        String[] values = this.getParameterValues(name);
        if (values != null) {
            return values;
        }
        return defaultValues;
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributeMap_.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributeMap_.keySet());
    }

    @Override
    public void removeAttribute(String name) {
        this.attributeMap_.remove(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributeMap_.put(name, value);
    }

    public Locale getLocale() {
        return this.locale_;
    }

    public void setLocale(Locale locale) {
        this.locale_ = locale;
    }

    public MatchedPathMapping getMatchedPathMapping() {
        return this.matchedPathMapping_;
    }

    public MockRequest setMatchedPathMapping(MatchedPathMapping matchedPathMapping) {
        this.matchedPathMapping_ = matchedPathMapping;
        return this;
    }

    @Override
    public Dispatch getCurrentDispatch() {
        return this.dispatch_;
    }

    @Override
    public Dispatch getRequestDispatch() {
        return this.requestDispatch_;
    }

    @Override
    public void enterDispatch(Dispatch dispatch) {
        if (this.requestDispatch_ == null) {
            this.requestDispatch_ = dispatch;
        }
        this.dispatchStack_.addFirst(dispatch);
        this.dispatch_ = dispatch;
    }

    @Override
    public void leaveDispatch() {
        this.dispatchStack_.removeFirst();
        if (!this.dispatchStack_.isEmpty()) {
            this.dispatch_ = this.dispatchStack_.peek();
        } else {
            this.dispatch_ = null;
            this.requestDispatch_ = null;
        }
    }

    @Override
    public String getActionName() {
        return this.dispatch_.getActionName();
    }
}

