/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.message.impl;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.annotation.tiger.InitMethod;
import org.seasar.kvasir.util.collection.I18NProperties;
import org.seasar.kvasir.util.collection.I18NPropertiesBuilder;
import org.seasar.kvasir.util.el.EvaluationException;
import org.seasar.kvasir.util.el.TextTemplateEvaluator;
import org.seasar.kvasir.util.el.VariableResolver;
import org.seasar.kvasir.util.el.impl.SimpleTextTemplateEvaluator;
import org.seasar.ymir.Request;
import org.seasar.ymir.Ymir;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.locale.LocaleManager;
import org.seasar.ymir.message.MessageProvider;
import org.seasar.ymir.message.Messages;
import org.seasar.ymir.util.MessagesUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesImpl
implements Messages,
MessageProvider {
    private static final String SUFFIX_PAGE = "Page";
    private final Log log_ = LogFactory.getLog(MessagesImpl.class);
    private final List<String> path_ = new ArrayList<String>();
    private I18NProperties messages_;
    private TextTemplateEvaluator evaluator_ = new SimpleTextTemplateEvaluator();
    private MessageProvider[] messageProviders_ = new MessageProvider[]{this};
    private LocaleManager localeManager_;

    @Binding(bindingType=BindingType.MAY)
    public void setMessageProviders(MessageProvider[] messageProviders) {
        this.messageProviders_ = messageProviders;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setLocaleManager(LocaleManager localeManager) {
        this.localeManager_ = localeManager;
    }

    public void addPath(String path) {
        this.path_.add(path);
    }

    @InitMethod
    public void init() {
        if (this.path_.isEmpty()) {
            this.log_.warn((Object)"no message path specified");
        }
        I18NPropertiesBuilder propertiesBuilder = new I18NPropertiesBuilder();
        for (String path : this.path_) {
            propertiesBuilder.addPath(path);
        }
        this.messages_ = propertiesBuilder.build();
    }

    public String getProperty(String name) {
        this.updateMessages();
        return this.getProperty0(name);
    }

    protected String getProperty0(String name) {
        return this.resolveValue(this.getRawProperty(name));
    }

    protected String getRawProperty(String name) {
        for (MessageProvider provider : this.messageProviders_) {
            String value = provider.getMessageValue(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected String resolveValue(String value) {
        try {
            return this.evaluator_.evaluateAsString(value, new VariableResolver(){

                public Object getValue(Object key) {
                    String value = MessagesImpl.this.getProperty((String)key);
                    if (value != null) {
                        return value;
                    }
                    return "";
                }
            });
        }
        catch (EvaluationException ex) {
            this.log_.warn((Object)("Can't evaluate: " + value), (Throwable)ex);
            return value;
        }
    }

    public String getProperty(String name, Locale locale) {
        this.updateMessages();
        return this.getProperty0(name, locale);
    }

    protected String getProperty0(String name, Locale locale) {
        return this.resolveValue(this.getRawProperty(name, locale), locale);
    }

    protected String getRawProperty(String name, Locale locale) {
        for (MessageProvider provider : this.messageProviders_) {
            String value = provider.getMessageValue(name, locale);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected String resolveValue(String value, final Locale locale) {
        try {
            return this.evaluator_.evaluateAsString(value, new VariableResolver(){

                public Object getValue(Object key) {
                    String value = MessagesImpl.this.getProperty((String)key, locale);
                    if (value != null) {
                        return value;
                    }
                    return "";
                }
            });
        }
        catch (EvaluationException ex) {
            this.log_.warn((Object)("Can't evaluate: " + value + ": locale=" + locale), (Throwable)ex);
            return value;
        }
    }

    @Override
    public String getMessage(String name) {
        this.updateMessages();
        Locale locale = this.localeManager_.getLocale();
        String[] candidates = MessagesUtils.getMessageNameCandidates(name, this.getPageNameCandidates(this.getPageNames()));
        for (MessageProvider provider : this.messageProviders_) {
            for (String candidate : candidates) {
                String message = this.resolveValue(provider.getMessageValue(candidate, locale), locale);
                if (message == null) continue;
                return message;
            }
        }
        return null;
    }

    String[] getPageNames() {
        try {
            return MessagesUtils.getPageNames((Request)this.getYmir().getApplication().getS2Container().getComponent(Request.class));
        }
        catch (ComponentNotFoundRuntimeException ex) {
            return null;
        }
    }

    protected String[] getPageNameCandidates(String[] pageNames) {
        LinkedHashSet<String> candidates = new LinkedHashSet<String>();
        if (pageNames != null) {
            for (String pageName : pageNames) {
                this.gatherPageNameCandidates(pageName, candidates);
            }
        }
        return candidates.toArray(new String[0]);
    }

    protected void gatherPageNameCandidates(String pageName, Set<String> candidates) {
        if (pageName != null && pageName.length() > 0) {
            candidates.add(pageName);
            if (pageName.endsWith(SUFFIX_PAGE)) {
                candidates.add(pageName.substring(0, pageName.length() - SUFFIX_PAGE.length()));
            }
            for (int i = pageName.length() - 1; i >= 1; --i) {
                String name;
                char ch = pageName.charAt(i);
                if (ch != '_' || (name = pageName.substring(0, i)).endsWith("_")) continue;
                candidates.add(name);
            }
        }
    }

    void updateMessages() {
        if (this.getYmir().isUnderDevelopment()) {
            this.init();
        }
    }

    protected Ymir getYmir() {
        return YmirContext.getYmir();
    }

    @Override
    public String getMessageValue(String name, Locale locale) {
        return this.messages_.getProperty(name, locale);
    }

    @Override
    public String getMessageValue(String name) {
        return this.messages_.getProperty(name);
    }
}

