/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.batch;

import java.beans.Introspector;
import java.util.ArrayList;
import org.seasar.ymir.batch.Batch;
import org.seasar.ymir.batch.BatchLauncher;

public class Bootstrap {
    private static final String SUFFIX_BATCH = "Batch";

    public static void main(String[] args) throws Exception {
        String className = null;
        boolean raw = false;
        ArrayList<String> argList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("--raw")) {
                raw = true;
                continue;
            }
            if (className == null) {
                className = arg;
                continue;
            }
            argList.add(arg);
        }
        if (className == null) {
            System.out.println("Usage: Bootstrap ( --raw className | className | componentName )");
            System.exit(1);
            return;
        }
        Class<?> batchClass = null;
        String batchComponentName = null;
        if (!raw && className.indexOf(46) < 0) {
            batchComponentName = className;
            if (!batchComponentName.endsWith(SUFFIX_BATCH)) {
                batchComponentName = batchComponentName + SUFFIX_BATCH;
            }
            batchComponentName = Introspector.decapitalize(batchComponentName);
        } else {
            try {
                batchClass = Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                System.out.println("Class not found: " + className);
                System.exit(1);
                return;
            }
            catch (ClassCastException ex) {
                System.out.println("Specified class is not an sub-class of " + Batch.class.getName() + " class: " + className);
                System.exit(1);
                return;
            }
        }
        final Batch batch = raw ? (Batch)batchClass.newInstance() : (batchClass != null ? new BatchLauncher(batchClass) : new BatchLauncher(batchComponentName));
        if (!batch.init(argList.toArray(new String[0]))) {
            System.exit(1);
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    batch.destroy();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        System.exit(batch.execute());
    }
}

