/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebappSourceResourceCollector<R> {
    private File webappSourceRoot_;
    private Rule<R> rule_;

    public WebappSourceResourceCollector(File webappSourceRoot, Rule<R> rule) {
        this.webappSourceRoot_ = webappSourceRoot;
        this.rule_ = rule;
    }

    public List<R> collect() {
        ArrayList resourceList = new ArrayList();
        this.collect("", resourceList);
        return resourceList;
    }

    protected void collect(String path, List<R> resourceList) {
        File dir = path.length() == 0 ? this.webappSourceRoot_ : new File(this.webappSourceRoot_, path);
        File[] childFiles = dir.listFiles();
        for (int i = 0; i < childFiles.length; ++i) {
            String childName = childFiles[i].getName();
            String childPath = path + "/" + childName;
            if (this.shouldIgnore(childPath, childName)) continue;
            if (childFiles[i].isDirectory()) {
                this.collect(childPath, resourceList);
                continue;
            }
            this.rule_.add(childPath, resourceList);
        }
    }

    protected boolean shouldIgnore(String path, String name) {
        if (path.equals("/WEB-INF/classes") || path.equals("/WEB-INF/lib") || path.equals("/WEB-INF/web.xml") || path.equals("/META-INF")) {
            return true;
        }
        return "CVS".equals(name) || ".svn".equals(name) || "_svn".equals(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Rule<R> {
        public void add(String var1, List<R> var2);
    }
}

