/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.dbflute.constraint;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.IllegalClientCodeRuntimeException;
import org.seasar.ymir.Request;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.constraint.ConstraintUtils;
import org.seasar.ymir.constraint.ConstraintViolatedException;
import org.seasar.ymir.constraint.ValidationFailedException;
import org.seasar.ymir.constraint.impl.AbstractConstraint;
import org.seasar.ymir.converter.PropertyHandler;
import org.seasar.ymir.converter.TypeConversionException;
import org.seasar.ymir.converter.TypeConversionManager;
import org.seasar.ymir.converter.annotation.TypeConversionHint;
import org.seasar.ymir.dbflute.EntityManager;
import org.seasar.ymir.dbflute.constraint.annotation.FittedOnDBType;
import org.seasar.ymir.message.Messages;
import org.seasar.ymir.message.Note;
import org.seasar.ymir.message.Notes;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FittedOnDBTypeConstraint
extends AbstractConstraint<FittedOnDBType> {
    @Binding(bindingType=BindingType.MUST)
    protected AnnotationHandler annotationHandler;
    @Binding(bindingType=BindingType.MUST)
    protected EntityManager entityManager;
    @Binding(bindingType=BindingType.MUST, value="messages")
    protected Messages messages;
    @Binding(bindingType=BindingType.MUST)
    protected TypeConversionManager typeConversionManager_;

    protected String getConstraintKey() {
        return "fittedOnDBType";
    }

    public void confirm(Object component, Request request, FittedOnDBType annotation, AnnotatedElement element) throws ConstraintViolatedException {
        Class<?> clazz = null;
        if (element instanceof Class) {
            clazz = (Class<?>)element;
        } else if (element instanceof Method) {
            clazz = ((Method)element).getDeclaringClass();
        }
        if (!Entity.class.isAssignableFrom(clazz)) {
            throw new IllegalClientCodeRuntimeException("Cannot add @FittedOnType annotation to non-entity class element: " + clazz.getName());
        }
        Class<?> entityClass = clazz;
        Notes notes = new Notes();
        HashSet<String> suppressTypeCheckSet = new HashSet<String>(Arrays.asList(annotation.suppressTypeCheckFor()));
        HashSet<String> suppressEmptyCheckSet = new HashSet<String>(Arrays.asList(annotation.suppressEmptyCheckFor()));
        HashSet<String> suppressSizeCheckSet = new HashSet<String>(Arrays.asList(annotation.suppressSizeCheckFor()));
        if (element instanceof Class) {
            Entity entity = this.entityManager.newEntity(entityClass);
            Iterator itr = request.getParameterNames();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                PropertyHandler handler = this.typeConversionManager_.getPropertyHandler((Object)entity, name);
                if (handler == null) continue;
                this.confirm(request, name, this.entityManager.getColumnInfo(entityClass, name), handler.getPropertyType(), this.annotationHandler.getMarkedAnnotations((AnnotatedElement)handler.getWriteMethod(), TypeConversionHint.class), suppressTypeCheckSet.contains(name), suppressEmptyCheckSet.contains(name), suppressSizeCheckSet.contains(name), notes, annotation.messageKey(), annotation.namePrefixOnNote());
            }
        } else if (element instanceof Method) {
            String name = this.getPropertyName(element);
            this.confirm(request, name, this.entityManager.getColumnInfo(entityClass, name), this.getPropertyType(element), this.annotationHandler.getMarkedAnnotations(element, TypeConversionHint.class), suppressTypeCheckSet.contains(name), suppressEmptyCheckSet.contains(name), suppressSizeCheckSet.contains(name), notes, annotation.messageKey(), annotation.namePrefixOnNote());
        } else {
            throw new RuntimeException("May logic error");
        }
        if (notes.size() > 0) {
            throw new ValidationFailedException().setNotes(notes);
        }
    }

    void confirm(Request request, String name, ColumnInfo columnInfo, Class<?> type, Annotation[] hint, boolean suppressCheckForType, boolean suppressCheckForEmpty, boolean suppressCheckForSize, Notes notes, String messageKey, String namePrefixOnNote) {
        if (columnInfo == null) {
            return;
        }
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return;
        }
        if (!suppressCheckForEmpty && columnInfo.isNotNull()) {
            boolean exist = false;
            for (String value : values) {
                if (value.length() <= 0) continue;
                exist = true;
                break;
            }
            if (!exist) {
                notes.add(name, new Note(ConstraintUtils.getFullMessageKey((String)"required", (String)messageKey), new Object[]{namePrefixOnNote + name}));
                return;
            }
        }
        for (String value : values) {
            Integer size;
            if (value.length() == 0) continue;
            if (!suppressCheckForType) {
                try {
                    this.typeConversionManager_.tryToConvert((Object)value, type, hint);
                }
                catch (TypeConversionException ex) {
                    String typeName = this.getTypeName(type);
                    String constraintKey = this.getConstraintKey() + "." + typeName;
                    if ((messageKey == null || messageKey.length() == 0) && this.messages.getMessage(ConstraintUtils.getFullMessageKey((String)constraintKey)) == null) {
                        constraintKey = this.getConstraintKey();
                    }
                    notes.add(name, new Note(ConstraintUtils.getFullMessageKey((String)constraintKey, (String)messageKey), new Object[]{namePrefixOnNote + name, typeName}));
                }
            }
            if (suppressCheckForSize || columnInfo.getPropertyType() != String.class || (size = columnInfo.getColumnSize()) == null || value.length() <= size) continue;
            notes.add(name, new Note(ConstraintUtils.getFullMessageKey((String)(this.getConstraintKey() + ".size"), (String)messageKey), new Object[]{namePrefixOnNote + name, size}));
        }
    }

    protected String getTypeName(Class<?> type) {
        if (ClassUtils.isWrapper(type)) {
            type = ClassUtils.toPrimitive(type);
        }
        return ClassUtils.getShortName((Class)ClassUtils.toComponentType(type));
    }
}

