/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.response;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.seasar.kvasir.util.io.InputStreamFactory;
import org.seasar.ymir.ResponseType;
import org.seasar.ymir.impl.AsIsInputStreamFactory;
import org.seasar.ymir.response.ResponseBase;

public class SelfContainedResponse
extends ResponseBase {
    public static final String DEFAULT_BINARY_CONTENTTYPE = "application/octet-stream";
    public static final String DEFAULT_ASCII_CONTENTTYPE = "text/html; charset=UTF-8";
    private InputStreamFactory inputStreamFactory_;
    private String string_;
    private String contentType_;

    public SelfContainedResponse() {
    }

    public SelfContainedResponse(InputStreamFactory inputStreamFactory) {
        this(inputStreamFactory, DEFAULT_BINARY_CONTENTTYPE);
    }

    public SelfContainedResponse(InputStreamFactory inputStreamFactory, String contentType) {
        this.setInputStreamFactory(inputStreamFactory);
        this.setContentType(contentType);
    }

    public SelfContainedResponse(String string) {
        this(string, DEFAULT_ASCII_CONTENTTYPE);
    }

    public SelfContainedResponse(String string, String contentType) {
        this.setString(string);
        this.setContentType(contentType);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Content-Type: ").append(this.contentType_).append(", Content: ");
        if (this.string_ != null) {
            sb.append(this.string_);
        } else {
            sb.append("(inputStreamFactory)");
        }
        return sb.toString();
    }

    public ResponseType getType() {
        return ResponseType.SELF_CONTAINED;
    }

    public boolean isSubordinate() {
        return false;
    }

    public InputStream getInputStream() {
        InputStream inputStream;
        if (this.inputStreamFactory_ != null) {
            inputStream = this.inputStreamFactory_.getInputStream();
            this.inputStreamFactory_ = null;
        } else if (this.string_ != null) {
            String charset = this.getCharacterEncoding();
            if (charset == null) {
                charset = "ISO-8859-1";
            }
            try {
                inputStream = new ByteArrayInputStream(this.string_.getBytes(charset));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Unknown charset: " + charset, ex);
            }
        } else {
            inputStream = null;
        }
        return inputStream;
    }

    public void setInputStream(InputStream is) {
        if (is == null) {
            this.setInputStreamFactory(null);
        } else {
            this.setInputStreamFactory(new AsIsInputStreamFactory(is));
        }
    }

    public InputStreamFactory getInputStreamFactory() {
        return this.inputStreamFactory_;
    }

    public void setInputStreamFactory(InputStreamFactory inputStreamFactory) {
        this.setInputStreamFactory0(inputStreamFactory);
        this.setString0(null);
    }

    void setInputStreamFactory0(InputStreamFactory inputStreamFactory) {
        InputStream is;
        if (this.inputStreamFactory_ != null && (is = this.inputStreamFactory_.getInputStream()) != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.inputStreamFactory_ = inputStreamFactory;
    }

    public String getString() {
        return this.string_;
    }

    public void setString(String string) {
        this.setInputStreamFactory0(null);
        this.setString0(string);
    }

    void setString0(String string) {
        this.string_ = string;
    }

    public String getContentType() {
        return this.contentType_;
    }

    public void setContentType(String contentType) {
        this.contentType_ = contentType;
    }
}

