/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.zpt;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import net.skirnir.freyja.Element;
import net.skirnir.freyja.Macro;
import net.skirnir.freyja.TemplateEvaluator;
import net.skirnir.freyja.TemplateSet;
import net.skirnir.freyja.impl.AbstractPathTemplateSet;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.Template;
import org.seasar.ymir.extension.creator.impl.NullTemplate;
import org.seasar.ymir.extension.zpt.TemplatePathResolver;

public class AnalyzerTemplateSet
implements TemplateSet {
    private TemplateSet templateSet_;
    private TemplateSet localTemplateSet_;

    public AnalyzerTemplateSet(TemplateEvaluator evaluator, TemplateSet templateSet, SourceCreator sourceCreator, TemplatePathResolver resolver) {
        this.localTemplateSet_ = new LocalTemplateSet(evaluator, sourceCreator, resolver);
        this.templateSet_ = templateSet;
    }

    public String getCanonicalName(String baseTemplateName, String templateName) {
        if (this.templateSet_ != null) {
            return this.templateSet_.getCanonicalName(baseTemplateName, templateName);
        }
        return this.localTemplateSet_.getCanonicalName(baseTemplateName, templateName);
    }

    public Element[] getElements(String templateName, String macroName) {
        Element[] elements = this.localTemplateSet_.getElements(templateName, macroName);
        if (elements != null) {
            return elements;
        }
        if (this.templateSet_ != null) {
            return this.templateSet_.getElements(templateName, macroName);
        }
        return null;
    }

    public Element[] getElements(String templateName) {
        Element[] elements = this.localTemplateSet_.getElements(templateName);
        if (elements != null) {
            return elements;
        }
        if (this.templateSet_ != null) {
            return this.templateSet_.getElements(templateName);
        }
        return null;
    }

    public TemplateSet.Entry getEntry(String templateName) {
        TemplateSet.Entry entry = this.localTemplateSet_.getEntry(templateName);
        if (entry != null) {
            return entry;
        }
        if (this.templateSet_ != null) {
            return this.templateSet_.getEntry(templateName);
        }
        return null;
    }

    public Macro getMacro(TemplateSet.Entry entry, String macroName) {
        Macro macro = this.localTemplateSet_.getMacro(entry, macroName);
        if (macro != null) {
            return macro;
        }
        if (this.templateSet_ != null) {
            return this.templateSet_.getMacro(entry, macroName);
        }
        return null;
    }

    public Macro getMacro(String templateName, String macroName) {
        Macro macro = this.localTemplateSet_.getMacro(templateName, macroName);
        if (macro != null) {
            return macro;
        }
        if (this.templateSet_ != null) {
            return this.templateSet_.getMacro(templateName, macroName);
        }
        return null;
    }

    public Long getSerialNumber(String templateName) {
        Long serialNumber = this.localTemplateSet_.getSerialNumber(templateName);
        if (serialNumber != null) {
            return serialNumber;
        }
        if (this.templateSet_ != null) {
            return this.templateSet_.getSerialNumber(templateName);
        }
        return null;
    }

    public boolean hasEntry(String templateName) {
        if (this.localTemplateSet_.hasEntry(templateName)) {
            return true;
        }
        if (this.templateSet_ != null) {
            return this.templateSet_.hasEntry(templateName);
        }
        return false;
    }

    private class LocalTemplateSet
    extends AbstractPathTemplateSet {
        private SourceCreator sourceCreator_;
        private TemplatePathResolver resolver_;

        public LocalTemplateSet(TemplateEvaluator evaluator, SourceCreator sourceCreator, TemplatePathResolver resolver) {
            super(sourceCreator.getTemplateEncoding(), evaluator);
            this.sourceCreator_ = sourceCreator;
            this.resolver_ = resolver;
        }

        protected InputStream getInputStream(String templateName) {
            Template tempate = this.getTemplate(templateName);
            if (!tempate.exists()) {
                return null;
            }
            try {
                return tempate.getInputStream();
            }
            catch (IOException ex) {
                return null;
            }
        }

        public Long getSerialNumber(String templateName) {
            return this.getTemplate(templateName).lastModified();
        }

        public boolean hasEntry(String templateName) {
            return this.getTemplate(templateName).exists();
        }

        Template getTemplate(String templateName) {
            String localPath = this.resolver_.getLocalPath(templateName, this.getHttpServletRequest());
            if (localPath != null) {
                return this.sourceCreator_.getTemplateProvider().getTemplate(localPath);
            }
            return NullTemplate.INSTANCE;
        }

        HttpServletRequest getHttpServletRequest() {
            return (HttpServletRequest)this.sourceCreator_.getApplication().getS2Container().getComponent(HttpServletRequest.class);
        }
    }
}

