/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.seasar.ymir.extension.creator.ThrowsDesc;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowsDescImpl
implements ThrowsDesc {
    private Set<String> throwableClassNameSet_ = new LinkedHashSet<String>();
    private Set<String> touchedClassNameSet_ = new HashSet<String>();

    public ThrowsDescImpl() {
    }

    public ThrowsDescImpl(Class<?> throwableClass) {
        this.addThrowable(throwableClass);
    }

    public ThrowsDescImpl(String throwableClassName) {
        this.addThrowable(throwableClassName);
    }

    @Override
    public ThrowsDesc addThrowable(Class<?> throwableClass) {
        return this.addThrowable(throwableClass.getName());
    }

    @Override
    public ThrowsDesc addThrowable(String throwableClassName) {
        this.throwableClassNameSet_.add(throwableClassName);
        return this;
    }

    @Override
    public String[] getThrowableClassNames() {
        return this.throwableClassNameSet_.toArray(new String[0]);
    }

    @Override
    public String[] getThrowableClassShortNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (String className : this.throwableClassNameSet_) {
            this.touchedClassNameSet_.add(className);
            list.add(ClassUtils.getShortName((String)className));
        }
        return list.toArray(new String[0]);
    }

    @Override
    public boolean isEmpty() {
        return this.throwableClassNameSet_.isEmpty();
    }

    @Override
    public void addDependingClassNamesTo(Set<String> set) {
        for (String className : this.throwableClassNameSet_) {
            set.add(className);
        }
    }

    @Override
    public void setTouchedClassNameSet(Set<String> set) {
        if (set == this.touchedClassNameSet_) {
            return;
        }
        this.touchedClassNameSet_ = set;
    }
}

