/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.util;

import java.util.ArrayList;
import org.seasar.ymir.Dispatch;
import org.seasar.ymir.Dispatcher;
import org.seasar.ymir.Request;

public class MessagesUtils {
    private static final String[] EMPTY_STRING = new String[0];

    protected MessagesUtils() {
    }

    public static String getPageName(Request request) {
        String[] pageNames = MessagesUtils.getPageNames(request);
        if (pageNames.length == 0) {
            return null;
        }
        return pageNames[0];
    }

    public static String[] getPageNames(Request request) {
        if (request == null) {
            return EMPTY_STRING;
        }
        Dispatch dispatch = request.getCurrentDispatch();
        String pageName = dispatch.getPageComponentName();
        if (dispatch.getDispatcher() == Dispatcher.REQUEST) {
            if (pageName == null) {
                return EMPTY_STRING;
            }
            return new String[]{pageName};
        }
        ArrayList<String> pageNames = new ArrayList<String>();
        if (pageName != null) {
            pageNames.add(pageName);
        }
        if ((pageName = request.getRequestDispatch().getPageComponentName()) != null) {
            pageNames.add(pageName);
        }
        return pageNames.toArray(EMPTY_STRING);
    }

    public static String[] getMessageNameCandidates(String name, String[] pageNameCandidates) {
        ArrayList<String> candidates = new ArrayList<String>();
        int dot = name.indexOf(46);
        if (dot < 0) {
            for (String pageNameCandidate : pageNameCandidates) {
                candidates.add(pageNameCandidate + "." + name);
            }
        } else {
            String prefix = name.substring(0, dot) + ".";
            String suffix = name.substring(dot);
            for (String pageNameCandidate : pageNameCandidates) {
                candidates.add(prefix + pageNameCandidate + suffix);
            }
        }
        candidates.add(name);
        return candidates.toArray(new String[0]);
    }
}

