/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.redirection.impl;

import javax.servlet.http.Cookie;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.Request;
import org.seasar.ymir.redirection.impl.AbstractScopeIdManager;
import org.seasar.ymir.window.WindowManager;

public class CookieScopeIdManager
extends AbstractScopeIdManager {
    private WindowManager windowManager_;

    @Binding(bindingType=BindingType.MUST)
    public void setWindowManager(WindowManager windowManager) {
        this.windowManager_ = windowManager;
    }

    public String getScopeId() {
        String cookieName = this.getCookieName();
        Cookie[] cookies = this.getHttpServletRequest().getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookieName.equals(cookies[i].getName())) continue;
                return cookies[i].getValue();
            }
        }
        return null;
    }

    String getCookieName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getScopeIdKey());
        String windowId = this.windowManager_.getWindowId();
        if (windowId != null) {
            sb.append(".").append(windowId);
        }
        return sb.toString();
    }

    public String populateScopeId(boolean scopeExists) {
        String scopeId = this.getScopeIdForNextRequest();
        if (scopeExists) {
            Cookie cookie = this.newCookie(this.getRequest(), scopeId);
            this.getHttpServletResponse().addCookie(cookie);
        } else if (this.getScopeId() != null) {
            Cookie cookie = this.newCookie(this.getRequest(), "");
            cookie.setMaxAge(0);
            this.getHttpServletResponse().addCookie(cookie);
        }
        return scopeId;
    }

    Cookie newCookie(Request request, String value) {
        Cookie cookie = new Cookie(this.getCookieNameForNextRequest(), value);
        String path = request.getContextPath();
        if (path.length() == 0) {
            path = "/";
        }
        cookie.setPath(path);
        return cookie;
    }

    String getCookieNameForNextRequest() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getScopeIdKey());
        String windowId = this.windowManager_.getWindowIdForNextRequest();
        if (windowId != null) {
            sb.append(".").append(windowId);
        }
        return sb.toString();
    }
}

