/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.plugin;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.Action;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.PageComponent;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.cache.CacheManager;
import org.seasar.ymir.interceptor.impl.AbstractYmirProcessInterceptor;
import org.seasar.ymir.plugin.Plugin;
import org.seasar.ymir.plugin.annotation.PluginAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInterceptor
extends AbstractYmirProcessInterceptor {
    private static final Comparator<Pair<?>> COMPARATOR_PAIR = new Comparator<Pair<?>>(){

        @Override
        public int compare(Pair<?> o1, Pair<?> o2) {
            return (int)Math.signum(o1.getPlugin().getPriority() - o2.getPlugin().getPriority());
        }
    };
    private static final Pair<?>[] EMPTY_PAIRS = new Pair[0];
    private AnnotationHandler annotationHandler_;
    private ApplicationManager applicationManager_;
    protected Map<Class<?>, Pair<?>[]> pairsByClassMap_;
    protected Map<Method, Pair<?>[]> pairsByMethodMap_;
    private ThreadLocal<Pair<?>[]> pairs_ = new ThreadLocal();

    @Binding(bindingType=BindingType.MUST)
    public void setAnnotationHandler(AnnotationHandler annotationHandler) {
        this.annotationHandler_ = annotationHandler;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setCacheManager(CacheManager cacheManager) {
        this.pairsByClassMap_ = cacheManager.newMap();
        this.pairsByMethodMap_ = cacheManager.newMap();
    }

    @Override
    public PageComponent pageComponentCreated(Request request, PageComponent pageComponent) {
        Pair<?>[] pairs = this.getPairs(pageComponent.getPageClass());
        for (int i = 0; i < pairs.length; ++i) {
            pairs[i].pageComponentCreated(request, pageComponent);
        }
        return pageComponent;
    }

    Pair<?>[] getPairs(Class<?> clazz) {
        Pair<?>[] pairs = this.pairsByClassMap_.get(clazz);
        if (pairs == null) {
            pairs = this.createPairs(clazz);
            this.pairsByClassMap_.put(clazz, pairs);
        }
        return pairs;
    }

    Pair<?>[] createPairs(AnnotatedElement element) {
        S2Container container = this.applicationManager_.findContextApplication().getS2Container();
        Annotation[] annotations = this.annotationHandler_.getMarkedAnnotations(element, PluginAnnotation.class);
        Pair[] pairs = new Pair[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            PluginAnnotation plugin = annotations[i].annotationType().getAnnotation(PluginAnnotation.class);
            pairs[i] = new Pair<Annotation>((Plugin)container.getComponent(plugin.value()), annotations[i]);
        }
        PluginInterceptor.sortPairs(pairs);
        return pairs;
    }

    static void sortPairs(Pair<?>[] pairs) {
        if (pairs != null) {
            Arrays.sort(pairs, COMPARATOR_PAIR);
        }
    }

    @Override
    public Action actionInvoking(Request request, Action action) {
        Pair<?>[] pairs = this.getPairs(request, action);
        this.pairs_.set(pairs);
        for (int i = 0; i < pairs.length; ++i) {
            action = pairs[i].actionInvoking(request, action);
        }
        return action;
    }

    Pair<?>[] getPairs(Request request, Action action) {
        Pair<?>[] pairsForClass = this.getPairs(request.getCurrentDispatch().getPageComponent().getPageClass());
        if (action == null) {
            return pairsForClass;
        }
        Method method = action.getMethodInvoker().getMethod();
        if (method == null) {
            return pairsForClass;
        }
        Pair<?>[] pairsForMethod = this.pairsByMethodMap_.get(method);
        if (pairsForMethod == null) {
            pairsForMethod = this.createPairs(method);
            this.pairsByMethodMap_.put(method, pairsForMethod);
        }
        return this.merge(pairsForClass, pairsForMethod);
    }

    Pair<?>[] merge(Pair<?>[] pair1, Pair<?>[] pair2) {
        int i;
        IdentityHashMap map = new IdentityHashMap();
        for (i = 0; i < pair1.length; ++i) {
            map.put(pair1[i].getPlugin(), pair1[i]);
        }
        for (i = 0; i < pair2.length; ++i) {
            map.put(pair2[i].getPlugin(), pair2[i]);
        }
        Pair[] pairs = map.values().toArray(new Pair[0]);
        PluginInterceptor.sortPairs(pairs);
        return pairs;
    }

    @Override
    public Response actionInvoked(Request request, Response response) {
        Pair<?>[] pairs = this.getPairs();
        for (int i = 0; i < pairs.length; ++i) {
            response = pairs[i].actionInvoked(request, response);
        }
        return response;
    }

    @Override
    public Response responseCreated(Request request, Response response) {
        Pair<?>[] pairs = this.getPairs();
        for (int i = 0; i < pairs.length; ++i) {
            response = pairs[i].responseCreated(request, response);
        }
        return response;
    }

    Pair<?>[] getPairs() {
        Pair<?>[] pairs = this.pairs_.get();
        if (pairs == null) {
            pairs = EMPTY_PAIRS;
        }
        return pairs;
    }

    @Override
    public void responseProcessingStarted(ServletContext context, HttpServletRequest httpRequest, HttpServletResponse httpResponse, Request request, Response response) {
        Pair<?>[] pairs = this.getPairs();
        for (int i = 0; i < pairs.length; ++i) {
            pairs[i].responseProcessingStarted(context, httpRequest, httpResponse, request, response);
        }
    }

    @Override
    public void leavingRequest(Request request) {
        Pair<?>[] pairs = this.getPairs();
        for (int i = 0; i < pairs.length; ++i) {
            pairs[i].leavingRequest(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leftRequest() {
        try {
            Pair<?>[] pairs = this.getPairs();
            for (int i = 0; i < pairs.length; ++i) {
                pairs[i].leftRequest();
            }
        }
        finally {
            this.pairs_.set(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pair<A extends Annotation> {
        private Plugin<A> plugin_;
        private A annotation_;

        public Pair(Plugin<A> plugin, A annotation) {
            this.plugin_ = plugin;
            this.annotation_ = annotation;
        }

        public Plugin<A> getPlugin() {
            return this.plugin_;
        }

        public A getAnnotation() {
            return this.annotation_;
        }

        public double getPriority() {
            return this.plugin_.getPriority();
        }

        public PageComponent pageComponentCreated(Request request, PageComponent pageComponent) {
            return this.plugin_.pageComponentCreated(request, pageComponent, this.annotation_);
        }

        public Action actionInvoking(Request request, Action action) {
            return this.plugin_.actionInvoking(request, action, this.annotation_);
        }

        public Response actionInvoked(Request request, Response response) {
            return this.plugin_.actionInvoked(request, response, this.annotation_);
        }

        public Response responseCreated(Request request, Response response) {
            return this.plugin_.responseCreated(request, response, this.annotation_);
        }

        public void responseProcessingStarted(ServletContext context, HttpServletRequest httpRequest, HttpServletResponse httpResponse, Request request, Response response) {
            this.plugin_.responseProcessingStarted(context, httpRequest, httpResponse, request, response, this.annotation_);
        }

        public void leavingRequest(Request request) {
            this.plugin_.leavingRequest(request, this.annotation_);
        }

        public void leftRequest() {
            this.plugin_.leftRequest(this.annotation_);
        }
    }
}

