/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.ymir.Application;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.convention.YmirNamingConvention;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtils {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final String DASH = "...";
    private static final String PACKAGEPREFIX_JAVA_LANG = "java.lang.";
    private static final String SUFFIX_ARRAY = "[]";
    private static ClassPool cp_ = new ClassPool(null);
    private static Map<String, Class<?>> primitiveClassByNameMap_;
    private static final Map<Class<?>, Class<?>> primitiveByWrapperMap_;
    private static final Map<Class<?>, Class<?>> wrapperByPrimitiveMap_;
    private static final Map<String, Object> defaultValueMap_;

    protected ClassUtils() {
    }

    public static <T> T newInstance(Class<T> clazz) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return ClassUtils.newInstanceFromAbstractClass(clazz);
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Can't instantiate: " + clazz.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Can't access to constructor: " + clazz.getName(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T newInstanceFromAbstractClass(Class<T> clazz) {
        CtClass cc;
        ClassPool classPool = cp_;
        synchronized (classPool) {
            CtClass ctClass;
            try {
                ctClass = cp_.get(clazz.getName());
            }
            catch (NotFoundException ex) {
                cp_.appendClassPath((ClassPath)new ClassClassPath(clazz));
                try {
                    ctClass = cp_.get(clazz.getName());
                }
                catch (NotFoundException ex1) {
                    throw new RuntimeException("Can't happen!", ex);
                }
            }
            cc = cp_.makeClass(clazz.getName() + "$$" + new Object().hashCode() + "$$", ctClass);
        }
        try {
            Object instance = cc.toClass().newInstance();
            return instance;
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Can't instantiate: " + clazz.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Can't access to constructor: " + clazz.getName(), ex);
        }
        catch (CannotCompileException ex) {
            throw new RuntimeException("Can't compile enhanced class of: " + clazz.getName(), ex);
        }
    }

    public static Method[] getMethods(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].isBridge() || methods[i].isSynthetic()) continue;
            methodList.add(methods[i]);
        }
        return methodList.toArray(new Method[0]);
    }

    public static Method[] getMethods(Object object, String methodName) {
        return ClassUtils.getMethods(object.getClass(), methodName);
    }

    public static Method getMethod(Object object, String methodName, Class<?> ... parameterTypes) {
        return ClassUtils.getMethod(object.getClass(), methodName, parameterTypes);
    }

    public static Method[] getMethods(Class<?> clazz, String methodName) {
        Method[] methods = ClassUtils.getMethods(clazz);
        ArrayList<Method> list = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            list.add(methods[i]);
        }
        return list.toArray(new Method[0]);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (SecurityException ex) {
            return null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Class<?> toComponentType(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        return clazz;
    }

    public static String getShortName(Object obj) {
        if (obj == null) {
            return null;
        }
        return ClassUtils.getShortName(obj.getClass());
    }

    public static String getShortName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassUtils.getShortName(clazz.getName());
    }

    public static String getShortName(String className) {
        if (className == null) {
            return null;
        }
        int dot = className.lastIndexOf(46);
        if (dot >= 0) {
            return className.substring(dot + 1);
        }
        return className;
    }

    public static String getShorterName(Object obj) {
        if (obj == null) {
            return null;
        }
        return ClassUtils.getShorterName(obj.getClass());
    }

    public static String getShorterName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassUtils.getShorterName(clazz.getName());
    }

    public static String getShorterName(String className) {
        if (className == null) {
            return null;
        }
        int dot = className.lastIndexOf(46);
        String shorterName = dot >= 0 ? className.substring(dot + 1) : className;
        for (int i = 0; i < shorterName.length(); ++i) {
            char ch = shorterName.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_') continue;
            return shorterName.substring(0, i);
        }
        return shorterName;
    }

    static String[] getRootPackageNames() {
        YmirNamingConvention namingConvention;
        Application application = YmirContext.getYmir().getApplication();
        if (application == null) {
            return EMPTY_STRINGS;
        }
        try {
            namingConvention = (YmirNamingConvention)((Object)application.getS2Container().getComponent(YmirNamingConvention.class));
        }
        catch (ComponentNotFoundRuntimeException ex) {
            return EMPTY_STRINGS;
        }
        return namingConvention.getRootPackageNames();
    }

    public static String getPrettyName(Object obj) {
        if (obj == null) {
            return null;
        }
        return ClassUtils.getPrettyName(obj.getClass());
    }

    public static String getPrettyName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassUtils.getPrettyName(clazz.getName());
    }

    public static String getPrettyName(String className) {
        if (className == null) {
            return null;
        }
        String prettyName = null;
        for (String rootPackageName : ClassUtils.getRootPackageNames()) {
            if (!className.startsWith(rootPackageName + ".")) continue;
            prettyName = DASH + className.substring(rootPackageName.length() + 1);
            break;
        }
        if (prettyName == null) {
            int dot = className.lastIndexOf(46);
            prettyName = dot >= 0 ? className.substring(dot + 1) : className;
        }
        for (int i = 0; i < prettyName.length(); ++i) {
            char ch = prettyName.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch == '.') continue;
            return prettyName.substring(0, i);
        }
        return prettyName;
    }

    public static boolean isPrimitive(String className) {
        return wrapperByPrimitiveMap_.containsKey(ClassUtils.getPrimitive(className));
    }

    public static Class<?> getPrimitive(String primitiveName) {
        return primitiveClassByNameMap_.get(primitiveName);
    }

    public static Class<?> toWrapper(Class<?> primitiveClass) {
        return wrapperByPrimitiveMap_.get(primitiveClass);
    }

    public static boolean isWrapper(Class<?> clazz) {
        return primitiveByWrapperMap_.containsKey(clazz);
    }

    public static boolean isWrapper(String className) {
        try {
            return primitiveByWrapperMap_.containsKey(className != null ? ClassUtils.forName(className) : null);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassUtils.class.getClassLoader();
        }
        return cl.loadClass(className);
    }

    public static Class<?> toPrimitive(Class<?> wrapperClass) {
        return primitiveByWrapperMap_.get(wrapperClass);
    }

    public static Object getDefaultValue(String className) {
        return defaultValueMap_.get(className);
    }

    public static String getPackageName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassUtils.getPackageName(clazz.getName());
    }

    public static String getPackageName(String className) {
        if (className == null) {
            return null;
        }
        int dot = className.lastIndexOf(46);
        if (dot < 0) {
            return "";
        }
        return className.substring(0, dot);
    }

    public static boolean isJavaLang(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return ClassUtils.isJavaLang(clazz.getName());
    }

    public static boolean isJavaLang(String className) {
        if (className == null) {
            return false;
        }
        return className.startsWith(PACKAGEPREFIX_JAVA_LANG) && className.indexOf(46, PACKAGEPREFIX_JAVA_LANG.length()) < 0;
    }

    public static String getNormalizedName(String className) {
        if (ClassUtils.isJavaLang(className)) {
            return className.substring(PACKAGEPREFIX_JAVA_LANG.length());
        }
        return className;
    }

    public static boolean isStandard(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return ClassUtils.isStandard(clazz.getName());
    }

    public static boolean isStandard(String className) {
        if (className == null) {
            return false;
        }
        return className.equals(Void.TYPE.getName()) || ClassUtils.isPrimitive(className) || ClassUtils.isJavaLang(className);
    }

    public static boolean isCapable(Object value, Class<?> type) {
        if (type == Void.TYPE) {
            return false;
        }
        if (value == null) {
            return !type.isPrimitive();
        }
        if (type.isPrimitive()) {
            Class<?> clazz = value.getClass();
            if (type == Short.TYPE) {
                return clazz == Short.class || clazz == Byte.class;
            }
            if (type == Integer.TYPE) {
                return clazz == Integer.class || clazz == Short.class || clazz == Byte.class || clazz == Character.class;
            }
            if (type == Long.TYPE) {
                return clazz == Long.class || clazz == Integer.class || clazz == Short.class || clazz == Byte.class || clazz == Character.class;
            }
            if (type == Float.TYPE) {
                return clazz == Float.class || clazz == Long.class || clazz == Integer.class || clazz == Short.class || clazz == Byte.class || clazz == Character.class;
            }
            if (type == Double.TYPE) {
                return clazz == Double.class || clazz == Float.class || clazz == Long.class || clazz == Integer.class || clazz == Short.class || clazz == Byte.class || clazz == Character.class;
            }
            return clazz == ClassUtils.toWrapper(type);
        }
        return type.isAssignableFrom(value.getClass());
    }

    public static boolean isArray(String className) {
        if (className == null) {
            return false;
        }
        return className.endsWith(SUFFIX_ARRAY);
    }

    public static String getClassName(String componentName, boolean array) {
        if (componentName == null) {
            return null;
        }
        if (array) {
            return componentName + SUFFIX_ARRAY;
        }
        return componentName;
    }

    public static Collection<Class<?>> getAssignableClasses(Class<?> clazz) {
        LinkedHashSet set = new LinkedHashSet();
        ClassUtils.gatherAssignableClasses(clazz, set);
        return set;
    }

    static void gatherAssignableClasses(Class<?> clazz, Set<Class<?>> set) {
        if (set.contains(clazz)) {
            return;
        }
        Class<?> cl = clazz;
        do {
            set.add(cl);
            for (Class<?> ifc : cl.getInterfaces()) {
                ClassUtils.gatherAssignableClasses(ifc, set);
            }
        } while ((cl = cl.getSuperclass()) != null);
    }

    static {
        cp_.appendSystemPath();
        HashMap<String, Class<Comparable<Boolean>>> primitiveClassByNameMap = new HashMap<String, Class<Comparable<Boolean>>>();
        primitiveClassByNameMap.put("boolean", Boolean.TYPE);
        primitiveClassByNameMap.put("byte", Byte.TYPE);
        primitiveClassByNameMap.put("char", Character.TYPE);
        primitiveClassByNameMap.put("double", Double.TYPE);
        primitiveClassByNameMap.put("float", Float.TYPE);
        primitiveClassByNameMap.put("int", Integer.TYPE);
        primitiveClassByNameMap.put("long", Long.TYPE);
        primitiveClassByNameMap.put("short", Short.TYPE);
        primitiveClassByNameMap_ = Collections.unmodifiableMap(primitiveClassByNameMap);
        HashMap<Class, Class<Comparable<Boolean>>> primitiveByWrapperMap = new HashMap<Class, Class<Comparable<Boolean>>>();
        primitiveByWrapperMap.put(Boolean.class, Boolean.TYPE);
        primitiveByWrapperMap.put(Byte.class, Byte.TYPE);
        primitiveByWrapperMap.put(Character.class, Character.TYPE);
        primitiveByWrapperMap.put(Double.class, Double.TYPE);
        primitiveByWrapperMap.put(Float.class, Float.TYPE);
        primitiveByWrapperMap.put(Integer.class, Integer.TYPE);
        primitiveByWrapperMap.put(Long.class, Long.TYPE);
        primitiveByWrapperMap.put(Short.class, Short.TYPE);
        primitiveByWrapperMap_ = Collections.unmodifiableMap(primitiveByWrapperMap);
        HashMap<Class<Comparable<Boolean>>, Class> wrapperByPrimitiveMap = new HashMap<Class<Comparable<Boolean>>, Class>();
        wrapperByPrimitiveMap.put(Boolean.TYPE, Boolean.class);
        wrapperByPrimitiveMap.put(Byte.TYPE, Byte.class);
        wrapperByPrimitiveMap.put(Character.TYPE, Character.class);
        wrapperByPrimitiveMap.put(Double.TYPE, Double.class);
        wrapperByPrimitiveMap.put(Float.TYPE, Float.class);
        wrapperByPrimitiveMap.put(Integer.TYPE, Integer.class);
        wrapperByPrimitiveMap.put(Long.TYPE, Long.class);
        wrapperByPrimitiveMap.put(Short.TYPE, Short.class);
        wrapperByPrimitiveMap_ = Collections.unmodifiableMap(wrapperByPrimitiveMap);
        HashMap<String, Comparable<Boolean>> defaultValueMap = new HashMap<String, Comparable<Boolean>>();
        defaultValueMap.put("boolean", Boolean.valueOf(false));
        defaultValueMap.put("byte", Byte.valueOf((byte)0));
        defaultValueMap.put("char", Character.valueOf('\u0000'));
        defaultValueMap.put("double", Double.valueOf(0.0));
        defaultValueMap.put("float", Float.valueOf(0.0f));
        defaultValueMap.put("int", Integer.valueOf(0));
        defaultValueMap.put("long", Long.valueOf(0L));
        defaultValueMap.put("short", Short.valueOf((short)0));
        defaultValueMap_ = Collections.unmodifiableMap(defaultValueMap);
    }
}

