/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.history;

import java.util.regex.Pattern;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.ymir.Dispatch;
import org.seasar.ymir.MatchedPathMapping;
import org.seasar.ymir.Path;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.conversation.ConversationManager;
import org.seasar.ymir.conversation.Conversations;
import org.seasar.ymir.history.Conversation;
import org.seasar.ymir.history.HistoryElement;
import org.seasar.ymir.history.HistoryManager;
import org.seasar.ymir.history.impl.HistoryElementImpl;
import org.seasar.ymir.interceptor.impl.AbstractYmirProcessInterceptor;
import org.seasar.ymir.util.RequestUtils;
import org.seasar.ymir.util.ResponseUtils;

public class HistoryInterceptor
extends AbstractYmirProcessInterceptor {
    private ConversationManager conversationManager_;
    private HistoryManager historyManager_;

    @Binding(bindingType=BindingType.MUST)
    public void setConversationManager(ConversationManager conversationManager) {
        this.conversationManager_ = conversationManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setHistoryManager(HistoryManager historyManager) {
        this.historyManager_ = historyManager;
    }

    public Response actionInvoked(Request request, Response response) {
        if (this.shouldRecordHistory(request, response)) {
            this.recordHistory(request);
        }
        return response;
    }

    protected boolean shouldRecordHistory(Request request, Response response) {
        if (!this.historyManager_.isRecording()) {
            return false;
        }
        if (!RequestUtils.isOriginalActionInvoked(request)) {
            return false;
        }
        if (ResponseUtils.isRedirect(response)) {
            return false;
        }
        MatchedPathMapping mapping = request.getCurrentDispatch().getMatchedPathMapping();
        if (mapping == null) {
            return false;
        }
        String path = request.getCurrentDispatch().getPath();
        for (Pattern pattern : this.historyManager_.getIgnorePathPatterns()) {
            if (!pattern.matcher(path).matches()) continue;
            return false;
        }
        return true;
    }

    protected void recordHistory(Request request) {
        this.historyManager_.getHistory().pushElement(this.newHistoryElement(request));
    }

    protected HistoryElement newHistoryElement(Request request) {
        org.seasar.ymir.conversation.Conversation conversation;
        HistoryElementImpl element = new HistoryElementImpl();
        Dispatch dispatch = request.getCurrentDispatch();
        element.setPath(new Path(dispatch.getPath(), dispatch.getQueryParameterMap()));
        Conversations conversations = this.conversationManager_.getConversations(false);
        if (conversations != null && (conversation = conversations.getCurrentConversation()) != null) {
            element.setConversation(new Conversation(conversation.getName(), conversation.getPhase()));
        }
        return element;
    }
}

