/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.custommonkey.xmlunit.TolerantSaxDocumentBuilder;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class HTMLDocumentBuilder {
    protected final TolerantSaxDocumentBuilder tolerantSaxDocumentBuilder;
    protected final SwingEvent2SaxAdapter swingEvent2SaxAdapter;
    private final StringBuffer traceBuffer;

    public HTMLDocumentBuilder(TolerantSaxDocumentBuilder tolerantSaxDocumentBuilder) {
        this.tolerantSaxDocumentBuilder = tolerantSaxDocumentBuilder;
        this.swingEvent2SaxAdapter = new SwingEvent2SaxAdapter();
        this.traceBuffer = new StringBuffer();
    }

    public Document parse(Reader reader) throws SAXException, IOException {
        this.traceBuffer.delete(0, this.traceBuffer.length());
        this.swingEvent2SaxAdapter.parse(reader, this.tolerantSaxDocumentBuilder);
        this.traceBuffer.append(this.tolerantSaxDocumentBuilder.getTrace());
        return this.tolerantSaxDocumentBuilder.getDocument();
    }

    public Document parse(String htmlString) throws SAXException, IOException {
        return this.parse(new StringReader(htmlString));
    }

    public String getTrace() {
        return this.traceBuffer.toString();
    }

    private void trace(String msg) {
        this.traceBuffer.append(msg).append('\n');
    }

    public class SwingEvent2SaxAdapter
    extends HTMLEditorKit.ParserCallback {
        private final boolean IGNORE_HTML_CHAR_SET = true;
        private final AttributesImpl attributes = new AttributesImpl();
        private final ParserDelegator delegator = new ParserDelegator();
        private boolean lastTagWasSimpleTag;
        private ContentHandler saxContentHandler;
        private SAXException firstUnhandledException;

        public void parse(Reader reader, ContentHandler saxContentHandler) throws SAXException, IOException {
            this.saxContentHandler = saxContentHandler;
            this.preParse();
            this.delegator.parse(reader, this, true);
            this.postParse();
        }

        private void preParse() throws SAXException {
            this.firstUnhandledException = null;
            this.saxContentHandler.startDocument();
        }

        private void postParse() throws SAXException {
            try {
                this.saxContentHandler.endDocument();
            }
            catch (SAXException e) {
                this.handleSAXException(e);
            }
            if (this.firstUnhandledException != null) {
                throw this.firstUnhandledException;
            }
        }

        public void flush() throws BadLocationException {
        }

        public void handleText(char[] data, int pos) {
            try {
                int startPos = this.lastTagWasSimpleTag ? this.getStartIgnoringClosingSimpleTag(data) : 0;
                if (startPos < data.length) {
                    this.saxContentHandler.characters(data, startPos, data.length);
                }
            }
            catch (SAXException e) {
                this.handleSAXException(e);
            }
        }

        private int getStartIgnoringClosingSimpleTag(char[] data) {
            if (data[0] == '>') {
                return 1;
            }
            return 0;
        }

        public void handleComment(char[] data, int pos) {
            if (this.saxContentHandler instanceof LexicalHandler) {
                try {
                    ((LexicalHandler)((Object)this.saxContentHandler)).comment(data, 0, data.length);
                }
                catch (SAXException e) {
                    this.handleSAXException(e);
                }
            } else {
                HTMLDocumentBuilder.this.trace("Unhandled comment " + new String(data));
            }
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet attributeSet, int pos) {
            try {
                this.saxContentHandler.startElement("", "", tag.toString(), this.convertToSaxAttributes(attributeSet));
            }
            catch (SAXException e) {
                this.handleSAXException(e);
            }
            this.lastTagWasSimpleTag = false;
        }

        public void handleEndTag(HTML.Tag tag, int pos) {
            try {
                this.saxContentHandler.endElement("", "", tag.toString());
            }
            catch (SAXException e) {
                this.handleSAXException(e);
            }
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attributeSet, int pos) {
            this.handleStartTag(tag, attributeSet, pos);
            this.handleEndTag(tag, pos);
            this.lastTagWasSimpleTag = true;
        }

        public void handleError(String errorMsg, int pos) {
            HTMLDocumentBuilder.this.trace("HTML ERROR: " + errorMsg);
        }

        private Attributes convertToSaxAttributes(MutableAttributeSet attributeSet) {
            this.attributes.clear();
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object attrName = enumeration.nextElement();
                Object attrValue = attributeSet.getAttribute(attrName);
                this.attributes.addAttribute("", "", attrName.toString(), "CDATA", attrValue.toString());
            }
            return this.attributes;
        }

        private void handleSAXException(SAXException e) {
            HTMLDocumentBuilder.this.trace("SAX Error: " + e.getMessage());
            if (this.firstUnhandledException == null) {
                this.firstUnhandledException = e;
            }
        }
    }
}

