/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.portlet.wrapper;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.servlet.ServletOutputStream;

public class ServletOutputStreamWrapper
extends ServletOutputStream {
    private OutputStream outputStream;

    public ServletOutputStreamWrapper(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if ((c & 0xFF00) != 0) {
                String errMsg = "Not an ISO 8859-1 character: {0}";
                Object[] errArgs = new Object[]{new Character(c)};
                errMsg = MessageFormat.format(errMsg, errArgs);
                throw new CharConversionException(errMsg);
            }
            this.write(c);
        }
    }

    public void print(boolean b) throws IOException {
        String msg = b ? "true" : "false";
        this.print(msg);
    }

    public void print(char c) throws IOException {
        this.print(String.valueOf(c));
    }

    public void print(int i) throws IOException {
        this.print(String.valueOf(i));
    }

    public void print(long l) throws IOException {
        this.print(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.print(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public void println() throws IOException {
        this.print("\r\n");
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.println();
    }

    public void println(boolean b) throws IOException {
        this.print(b);
        this.println();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.println();
    }

    public void println(int i) throws IOException {
        this.print(i);
        this.println();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.println();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.println();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.println();
    }

    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    public void close() throws IOException {
        this.outputStream.close();
    }

    public boolean equals(Object obj) {
        return this.outputStream.equals(obj);
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public int hashCode() {
        return this.outputStream.hashCode();
    }

    public String toString() {
        return this.outputStream.toString();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
    }
}

