/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.Assert;
import org.custommonkey.xmlunit.DoctypeReader;
import org.custommonkey.xmlunit.NodeInputStream;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Validator
extends DefaultHandler
implements ErrorHandler {
    private final InputSource validationInputSource;
    private final SAXParser parser;
    private final StringBuffer messages = new StringBuffer();
    private final boolean usingDoctypeReader;
    private Boolean isValid = null;

    protected Validator(InputSource inputSource, boolean usingDoctypeReader) throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = XMLUnit.getSAXParserFactory();
        factory.setValidating(true);
        this.parser = factory.newSAXParser();
        this.validationInputSource = inputSource;
        this.usingDoctypeReader = usingDoctypeReader;
    }

    public Validator(Document document, String systemID, String doctype) throws ParserConfigurationException, SAXException {
        this(new InputStreamReader(new NodeInputStream(document)), systemID, doctype);
    }

    public Validator(Reader readerForValidation) throws ParserConfigurationException, SAXException {
        this(new InputSource(readerForValidation), readerForValidation instanceof DoctypeReader);
    }

    public Validator(Reader readerForValidation, String systemID) throws ParserConfigurationException, SAXException {
        this(readerForValidation);
        this.validationInputSource.setSystemId(systemID);
    }

    public Validator(Reader readerForValidation, String systemID, String doctype) throws ParserConfigurationException, SAXException {
        this(new DoctypeReader(readerForValidation, doctype, systemID));
        this.validationInputSource.setSystemId(systemID);
    }

    public void useXMLSchema(boolean use) throws SAXException {
        this.parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/schema", use);
        this.parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/dynamic", use);
    }

    public boolean isValid() {
        this.validate();
        return this.isValid;
    }

    public void assertIsValid() {
        if (!this.isValid()) {
            Assert.fail((String)this.messages.toString());
        }
    }

    private StringBuffer appendMessage(StringBuffer toAppendTo) {
        if (this.isValid()) {
            return toAppendTo.append("[valid]");
        }
        return toAppendTo.append(this.messages);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString()).append(':');
        return this.appendMessage(buf).toString();
    }

    private void validate() {
        if (this.isValid != null) {
            return;
        }
        try {
            this.parser.parse(this.validationInputSource, (DefaultHandler)this);
        }
        catch (SAXException e) {
            this.parserException(e);
        }
        catch (IOException e) {
            this.parserException(e);
        }
        if (this.isValid == null) {
            this.isValid = Boolean.TRUE;
        } else if (this.usingDoctypeReader) {
            try {
                this.messages.append("\nContent was: ").append(((DoctypeReader)this.validationInputSource.getCharacterStream()).getContent());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void parserException(Exception e) {
        this.invalidate(e.getMessage());
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.errorHandlerException(exception);
    }

    public void error(SAXParseException exception) throws SAXException {
        this.errorHandlerException(exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.errorHandlerException(exception);
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (this.validationInputSource.getSystemId() != null) {
            return new InputSource(this.validationInputSource.getSystemId());
        }
        if (systemId != null) {
            return new InputSource(systemId);
        }
        return null;
    }

    private void errorHandlerException(Exception e) {
        this.invalidate(e.getMessage());
    }

    private void invalidate(String message) {
        this.isValid = Boolean.FALSE;
        this.messages.append(message).append(' ');
    }
}

