/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.core;

import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.webapp.UIComponentBodyTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import org.seasar.teeda.core.util.BindingUtil;
import org.seasar.teeda.core.util.ConverterUtil;

public class VerbatimTag
extends UIComponentBodyTag {
    private static final String COMPONENT_TYPE = "javax.faces.Output";
    private static final String RENDER_TYPE = "javax.faces.Text";
    private String escape = null;

    public String getComponentType() {
        return COMPONENT_TYPE;
    }

    public String getRendererType() {
        return RENDER_TYPE;
    }

    public void setEscape(String escape) {
        this.escape = escape;
    }

    public String getEscape() {
        return this.escape;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        String escapeStr = this.getEscape();
        if (escapeStr != null) {
            if (BindingUtil.isValueReference(escapeStr)) {
                BindingUtil.setValueBinding(component, "escape", escapeStr);
            } else {
                boolean escape = ConverterUtil.convertToBoolean(escapeStr);
                component.getAttributes().put("escape", escape ? Boolean.TRUE : Boolean.FALSE);
            }
        } else {
            component.getAttributes().put("escape", Boolean.FALSE);
        }
        component.setTransient(true);
    }

    public int doAfterBody() throws JspException {
        String value;
        BodyContent bodyContent = this.getBodyContent();
        if (bodyContent != null && (value = bodyContent.getString().trim()) != null) {
            UIOutput component = (UIOutput)this.getComponentInstance();
            component.setValue(value);
        }
        return super.doAfterBody();
    }
}

