/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;

public class HtmlOutputTextRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Output";
    public static final String RENDERER_TYPE = "javax.faces.Text";
    private final IgnoreAttribute ignoreComponent = new IgnoreAttribute();

    public HtmlOutputTextRenderer() {
        this.ignoreComponent.addAttributeName("id");
        this.ignoreComponent.addAttributeName("value");
        this.ignoreComponent.addAttributeName("escape");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        if (component instanceof HtmlOutputText) {
            this.encodeHtmlOutputTextEnd(context, (HtmlOutputText)component);
        } else if (component instanceof UIOutput) {
            this.encodeUIOutputEnd(context, (UIOutput)component);
        }
    }

    protected void encodeHtmlOutputTextEnd(FacesContext context, HtmlOutputText htmlOutputText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean startSpan = false;
        if (this.containsAttributeForRender(htmlOutputText, this.ignoreComponent)) {
            writer.startElement("span", htmlOutputText);
            startSpan = true;
            RendererUtil.renderIdAttributeIfNecessary(writer, htmlOutputText, this.getIdForRender(context, htmlOutputText));
            this.renderRemainAttributes(htmlOutputText, writer, this.ignoreComponent);
        }
        String value = ValueHolderUtil.getValueForRender(context, htmlOutputText);
        if (htmlOutputText.isEscape()) {
            writer.writeText(value, null);
        } else {
            writer.write(value);
        }
        if (startSpan) {
            writer.endElement("span");
        }
    }

    protected void encodeUIOutputEnd(FacesContext context, UIOutput uiOutput) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean startSpan = false;
        if (this.containsAttributeForRender(uiOutput, this.ignoreComponent)) {
            writer.startElement("span", uiOutput);
            startSpan = true;
            RendererUtil.renderIdAttributeIfNecessary(writer, uiOutput, this.getIdForRender(context, uiOutput));
            this.renderRemainAttributes(uiOutput, writer, this.ignoreComponent);
        }
        String value = ValueHolderUtil.getValueForRender(context, uiOutput);
        Boolean b = (Boolean)uiOutput.getAttributes().get("escape");
        if (b != null && b.booleanValue()) {
            writer.writeText(value, null);
        } else {
            writer.write(value);
        }
        if (startSpan) {
            writer.endElement("span");
        }
    }

    protected IgnoreAttribute getIgnoreAttribute() {
        return this.ignoreComponent;
    }

    protected void addIgnoreAttributeName(String attribute) {
        this.ignoreComponent.addAttributeName(attribute);
    }
}

