/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.html.HtmlForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import javax.faces.internal.WindowIdUtil;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.render.html.support.UrlBuilder;
import org.seasar.teeda.core.util.FacesContextUtil;
import org.seasar.teeda.core.util.HtmlFormRendererUtil;
import org.seasar.teeda.core.util.JavaScriptUtil;
import org.seasar.teeda.core.util.RendererUtil;

public class HtmlFormRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Form";
    public static final String RENDERER_TYPE = "javax.faces.Form";
    private static final String HIDDEN_PARAMETER_KEY = HtmlFormRenderer.class.getName() + ".HIDDEN_PARAMETER_KEY";
    private final IgnoreAttribute ignoreComponent = new IgnoreAttribute();

    public HtmlFormRenderer() {
        this.ignoreComponent.addAttributeName("id");
        this.ignoreComponent.addAttributeName("name");
        this.ignoreComponent.addAttributeName("method");
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlFormBegin(context, (HtmlForm)component);
    }

    protected void encodeHtmlFormBegin(FacesContext context, HtmlForm htmlForm) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("form", htmlForm);
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlForm, this.getIdForRender(context, htmlForm));
        RendererUtil.renderAttribute(writer, "name", (Object)htmlForm.getClientId(context));
        RendererUtil.renderAttribute(writer, "method", (Object)"post");
        this.renderRemainAttributes(htmlForm, writer, this.ignoreComponent);
        ViewHandler viewHandler = FacesContextUtil.getViewHandler(context);
        String viewId = context.getViewRoot().getViewId();
        String url = viewHandler.getActionURL(context, viewId);
        if (url != null) {
            UrlBuilder urlBuilder = new UrlBuilder();
            urlBuilder.setBase(url);
            String encoding = writer.getCharacterEncoding();
            if (WindowIdUtil.isNewWindowTarget(htmlForm.getTarget())) {
                urlBuilder.add(URLEncoder.encode("newwindow", encoding), URLEncoder.encode("true", encoding));
            }
            writer.writeURIAttribute("action", context.getExternalContext().encodeActionURL(urlBuilder.build()), null);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlFormEnd(context, (HtmlForm)component);
    }

    protected void encodeHtmlFormEnd(FacesContext context, HtmlForm htmlForm) throws IOException {
        context.getApplication().getViewHandler().writeState(context);
        ResponseWriter writer = context.getResponseWriter();
        this.renderFormSubmitMarker(context, htmlForm, writer);
        this.renderForCommandLink(context, htmlForm, writer);
        writer.endElement("form");
    }

    protected void renderForCommandLink(FacesContext context, HtmlForm htmlForm, ResponseWriter writer) throws IOException {
        Map hiddenParameters = HtmlFormRenderer.getCommandLinkHiddenParameters(htmlForm);
        boolean hasCommandLink = false;
        Iterator it = hiddenParameters.entrySet().iterator();
        while (it.hasNext()) {
            hasCommandLink = true;
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            RendererUtil.renderHidden(htmlForm, writer, name, value);
        }
        if (hasCommandLink) {
            String target = htmlForm.getTarget();
            this.renderClearHiddenCommandFormParamsFunction(writer, this.getIdForRender(context, htmlForm), hiddenParameters.entrySet(), target);
        }
        htmlForm.getAttributes().remove(HIDDEN_PARAMETER_KEY);
    }

    public static void setCommandLinkHiddenParameter(UIForm form, String key, Object value) {
        Map map = HtmlFormRenderer.getCommandLinkHiddenParameters(form);
        map.put(key, value);
    }

    public static Map getCommandLinkHiddenParameters(UIForm form) {
        Map attributes = form.getAttributes();
        LinkedHashMap map = (LinkedHashMap)attributes.get(HIDDEN_PARAMETER_KEY);
        if (map == null) {
            map = new LinkedHashMap();
            attributes.put(HIDDEN_PARAMETER_KEY, map);
        }
        return map;
    }

    public static void clearCommandLinkHiddenParameters(UIForm form, String key) {
        Map map = HtmlFormRenderer.getCommandLinkHiddenParameters(form);
        map.remove(key);
    }

    private void renderFormSubmitMarker(FacesContext context, HtmlForm htmlForm, ResponseWriter writer) throws IOException {
        String clientId = htmlForm.getClientId(context);
        String key = this.getFormSubmitKey(context, htmlForm);
        RendererUtil.renderHidden(htmlForm, writer, key, clientId);
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.decodeHtmlForm(context, (HtmlForm)component);
    }

    protected void decodeHtmlForm(FacesContext context, HtmlForm htmlForm) {
        String key;
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(key = this.getFormSubmitKey(context, htmlForm))) {
            htmlForm.setSubmitted(true);
        } else {
            htmlForm.setSubmitted(false);
        }
    }

    private String getFormSubmitKey(FacesContext context, HtmlForm htmlForm) {
        return HtmlFormRendererUtil.getFormSubmitKey(context, htmlForm);
    }

    protected void renderClearHiddenCommandFormParamsFunction(ResponseWriter writer, String formName, Set hiddenFormParams, String formTarget) throws IOException {
        String functionName = JavaScriptUtil.getClearHiddenCommandFormParamsFunctionName(formName);
        StringBuffer sb = new StringBuffer(512);
        sb.append("function ").append(functionName).append("(){");
        if (hiddenFormParams != null) {
            sb.append("var f = document.forms['").append(formName).append("'];");
            Iterator it = hiddenFormParams.iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String name = (String)entry.getKey();
                sb.append(" f.elements['").append(name).append("'].value='null';");
            }
        }
        sb.append(" f.target=");
        if (formTarget == null || formTarget.length() == 0) {
            sb.append("'';");
        } else {
            sb.append("'").append(formTarget).append("';");
        }
        sb.append("} ").append(functionName).append("();");
        this.renderJavaScriptElement(writer, new String(sb));
    }

    public void addIgnoreAttributeName(String name) {
        this.ignoreComponent.addAttributeName(name);
    }
}

