/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import javax.faces.application.Application;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import org.seasar.teeda.core.mock.MockPropertyResolver;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.PropertyResolverUtil;

public class PropertyResolverUtilTest
extends TeedaTestCase {
    public void testGetValue() {
        this.setPropertyResolver(new MockWrappedPropertyResolver());
        Object o = PropertyResolverUtil.getValue((Application)this.getApplication(), (Object)"hoge", (Object)"foo", null);
        PropertyResolverUtilTest.assertNotNull((Object)o);
        PropertyResolverUtilTest.assertTrue((boolean)(o instanceof MockWrappedPropertyResolver.ObjectValue));
        MockWrappedPropertyResolver.ObjectValue value = (MockWrappedPropertyResolver.ObjectValue)o;
        PropertyResolverUtilTest.assertEquals((Object)"hoge", (Object)value.getBase());
        PropertyResolverUtilTest.assertEquals((Object)"foo", (Object)value.getProperty());
        o = PropertyResolverUtil.getValue((Application)this.getApplication(), (Object)"hoge", (Object)"foo", (Integer)new Integer(1));
        PropertyResolverUtilTest.assertNotNull((Object)o);
        PropertyResolverUtilTest.assertTrue((boolean)(o instanceof MockWrappedPropertyResolver.IndexValue));
        MockWrappedPropertyResolver.IndexValue index = (MockWrappedPropertyResolver.IndexValue)o;
        PropertyResolverUtilTest.assertEquals((Object)"hoge", (Object)index.getBase());
        PropertyResolverUtilTest.assertEquals((int)1, (int)index.getIndex());
    }

    public void testGetType() {
        this.setPropertyResolver(new MockWrappedPropertyResolver());
        Class clazz = PropertyResolverUtil.getType((Application)this.getApplication(), (Object)"a", (Object)"b", null);
        PropertyResolverUtilTest.assertEquals((Object)MockWrappedPropertyResolver.ObjectValue.class, (Object)clazz);
        clazz = PropertyResolverUtil.getType((Application)this.getApplication(), (Object)"a", (Object)"b", (Integer)new Integer(2));
        PropertyResolverUtilTest.assertEquals((Object)MockWrappedPropertyResolver.IndexValue.class, (Object)clazz);
    }

    public void testIsReadOnly() {
        this.setPropertyResolver(new MockWrappedPropertyResolver());
        PropertyResolverUtilTest.assertFalse((boolean)PropertyResolverUtil.isReadOnly((Application)this.getApplication(), (Object)"hoge", (Object)"foo", null));
        PropertyResolverUtilTest.assertTrue((boolean)PropertyResolverUtil.isReadOnly((Application)this.getApplication(), (Object)"hoge", (Object)"foo", (Integer)new Integer(3)));
    }

    public static class MockWrappedPropertyResolver
    extends MockPropertyResolver {
        public Object getValue(Object base, int index) throws EvaluationException, PropertyNotFoundException {
            return new IndexValue(base, index);
        }

        public Object getValue(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
            return new ObjectValue(base, property);
        }

        public Class getType(Object base, int index) throws EvaluationException, PropertyNotFoundException {
            return new IndexValue(base, index).getClass();
        }

        public Class getType(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
            return new ObjectValue(base, property).getClass();
        }

        public boolean isReadOnly(Object base, int index) throws EvaluationException, PropertyNotFoundException {
            return true;
        }

        public boolean isReadOnly(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
            return false;
        }

        public static class IndexValue {
            private Object base_;
            private int index_;

            public IndexValue(Object base, int index) {
                this.base_ = base;
                this.index_ = index;
            }

            public Object getBase() {
                return this.base_;
            }

            public int getIndex() {
                return this.index_;
            }
        }

        public static class ObjectValue {
            private Object base_;
            private Object property_;

            public ObjectValue(Object base, Object property) {
                this.base_ = base;
                this.property_ = property;
            }

            public Object getBase() {
                return this.base_;
            }

            public Object getProperty() {
                return this.property_;
            }
        }
    }
}

