/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.handler;

import java.util.List;
import java.util.Locale;
import org.seasar.teeda.core.config.faces.element.ApplicationElement;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.faces.element.LocaleConfigElement;
import org.seasar.teeda.core.config.faces.element.impl.ApplicationElementImpl;
import org.seasar.teeda.core.config.faces.handler.LocaleConfigTagHandler;
import org.seasar.teeda.core.config.faces.handler.TagHandlerTestCase;
import org.xml.sax.Attributes;

public class LocaleConfigTagHandlerTest
extends TagHandlerTestCase {
    public void testLocaleConfigHandler() {
        ApplicationElementImpl app = new ApplicationElementImpl();
        this.getContext().push((Object)app);
        LocaleConfigTagHandler handler = new LocaleConfigTagHandler();
        handler.start(this.getContext(), (Attributes)new TagHandlerTestCase.NullAttributes());
        LocaleConfigTagHandlerTest.assertTrue((boolean)(this.getContext().peek() instanceof LocaleConfigElement));
        handler.end(this.getContext(), "a");
        ApplicationElement app2 = (ApplicationElement)this.getContext().pop();
        LocaleConfigTagHandlerTest.assertEquals((Object)app, (Object)app2);
        List locales = app2.getLocaleConfigs();
        LocaleConfigTagHandlerTest.assertEquals((int)1, (int)locales.size());
        LocaleConfigTagHandlerTest.assertTrue((boolean)(locales.get(0) instanceof LocaleConfigElement));
    }

    public void testLocaleConfigHandlerByXMLParse() {
        FacesConfig config = this.parse("testLocaleConfigTagHandler.xml");
        List apps = config.getApplicationElements();
        LocaleConfigTagHandlerTest.assertNotNull(apps.get(0));
        ApplicationElement appElement = (ApplicationElement)apps.get(0);
        List localeConfigs = appElement.getLocaleConfigs();
        LocaleConfigTagHandlerTest.assertNotNull(localeConfigs.get(0));
        LocaleConfigElement localeConfig = (LocaleConfigElement)localeConfigs.get(0);
        LocaleConfigTagHandlerTest.assertEquals((Object)Locale.JAPANESE, (Object)localeConfig.getDefaultLocale());
        List supportedLocale = localeConfig.getSupportedLocales();
        LocaleConfigTagHandlerTest.assertEquals((Object)Locale.ENGLISH, supportedLocale.get(0));
        LocaleConfigTagHandlerTest.assertEquals((Object)Locale.FRENCH, supportedLocale.get(1));
    }
}

