/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.validator.AbstractValidatorTest;
import javax.faces.validator.DoubleRangeValidator;
import javax.faces.validator.LongRangeValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockUIComponent;

public class DoubleRangeValidatorTest
extends AbstractValidatorTest {
    public void testConstants() throws Exception {
        DoubleRangeValidatorTest.assertEquals((String)"javax.faces.validator.DoubleRangeValidator.MAXIMUM", (String)"javax.faces.validator.DoubleRangeValidator.MAXIMUM");
        DoubleRangeValidatorTest.assertEquals((String)"javax.faces.validator.DoubleRangeValidator.MINIMUM", (String)"javax.faces.validator.DoubleRangeValidator.MINIMUM");
        DoubleRangeValidatorTest.assertEquals((String)"javax.faces.validator.DoubleRangeValidator.TYPE", (String)"javax.faces.validator.DoubleRangeValidator.TYPE");
        DoubleRangeValidatorTest.assertEquals((String)"javax.faces.DoubleRange", (String)"javax.faces.DoubleRange");
    }

    public void testInstanciation_withMax() throws Exception {
        double d = 2.0;
        DoubleRangeValidator validator = new DoubleRangeValidator(d);
        DoubleRangeValidatorTest.assertTrue((2.0 == validator.getMaximum() ? 1 : 0) != 0);
    }

    public void testInstanciation_withMaxAndMin() throws Exception {
        double max = 2000.0;
        double min = 3.0;
        DoubleRangeValidator validator = new DoubleRangeValidator(max, min);
        DoubleRangeValidatorTest.assertTrue((2000.0 == validator.getMaximum() ? 1 : 0) != 0);
        DoubleRangeValidatorTest.assertTrue((3.0 == validator.getMinimum() ? 1 : 0) != 0);
    }

    public void testGetMaximum_setMax() throws Exception {
        DoubleRangeValidator validator = new DoubleRangeValidator(5.0);
        DoubleRangeValidatorTest.assertTrue((5.0 == validator.getMaximum() ? 1 : 0) != 0);
    }

    public void testGetMaximum_notSetMax() throws Exception {
        DoubleRangeValidator validator = new DoubleRangeValidator();
        DoubleRangeValidatorTest.assertTrue((Double.MAX_VALUE == validator.getMaximum() ? 1 : 0) != 0);
    }

    public void testGetMinimum_setMin() throws Exception {
        DoubleRangeValidator validator = new DoubleRangeValidator(8.0, 7.0);
        DoubleRangeValidatorTest.assertTrue((7.0 == validator.getMinimum() ? 1 : 0) != 0);
    }

    public void testGetMinimum_notSetMin() throws Exception {
        DoubleRangeValidator validator = new DoubleRangeValidator();
        DoubleRangeValidatorTest.assertTrue((Double.MIN_VALUE == validator.getMinimum() ? 1 : 0) != 0);
    }

    public void testValidate_lessThanMinWhenBothMaxMinNotNull() throws Exception {
        FacesContext context = this.getFacesContextWithSetMessageBundle("a", Locale.ENGLISH);
        DoubleRangeValidator validator = new DoubleRangeValidator(2.0, 1.0);
        try {
            validator.validate(context, (UIComponent)context.getViewRoot(), (Object)new Integer(0));
            DoubleRangeValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            DoubleRangeValidatorTest.assertEquals((String)"not in range(1,2,a)", (String)expected.getMessage());
            DoubleRangeValidatorTest.success();
        }
    }

    public void testValidate_lessThanMinWhenBothMaxMinNotNullWithLabel() throws Exception {
        this.getApplication().setMessageBundle("javax.faces.component.TestMessages");
        HtmlInputText component = new HtmlInputText();
        component.setLabel("hoge");
        component.setId("id");
        DoubleRangeValidator validator = new DoubleRangeValidator(2.0, 1.0);
        try {
            validator.validate((FacesContext)this.getFacesContext(), (UIComponent)component, (Object)new Integer(0));
            DoubleRangeValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            DoubleRangeValidatorTest.assertEquals((String)"not in range(1,2,hoge)", (String)expected.getMessage());
            DoubleRangeValidatorTest.success();
        }
    }

    public void testValidate_moreThanMaxWhenBothMaxMinNotNull() throws Exception {
        FacesContext context = this.getFacesContextWithSetMessageBundle("b", Locale.ENGLISH);
        DoubleRangeValidator validator = new DoubleRangeValidator(2.0, 1.0);
        try {
            validator.validate(context, (UIComponent)context.getViewRoot(), (Object)new Integer(3));
            DoubleRangeValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            DoubleRangeValidatorTest.assertEquals((String)"not in range(1,2,b)", (String)expected.getMessage());
            DoubleRangeValidatorTest.success();
        }
    }

    public void testValidate_moreThanMaxWhenBothMaxMinNotNullWithLabel() throws Exception {
        this.getApplication().setMessageBundle("javax.faces.component.TestMessages");
        HtmlInputText component = new HtmlInputText();
        component.setLabel("hoge");
        component.setId("id");
        DoubleRangeValidator validator = new DoubleRangeValidator(2.0, 1.0);
        try {
            validator.validate((FacesContext)this.getFacesContext(), (UIComponent)component, (Object)new Integer(3));
            DoubleRangeValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            DoubleRangeValidatorTest.assertEquals((String)"not in range(1,2,hoge)", (String)expected.getMessage());
            DoubleRangeValidatorTest.success();
        }
    }

    public void testValidate_lessThanMinWhenMinNotNull() throws Exception {
        FacesContext context = this.getFacesContextWithSetMessageBundle("a", Locale.ENGLISH);
        DoubleRangeValidator validator = new DoubleRangeValidator();
        validator.setMinimum(1.0);
        try {
            validator.validate(context, (UIComponent)context.getViewRoot(), (Object)new Integer(0));
            DoubleRangeValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            DoubleRangeValidatorTest.assertEquals((String)"less than min(1,a)", (String)expected.getMessage());
            DoubleRangeValidatorTest.success();
        }
    }

    public void testValidate_lessThanMinWhenMinNotNullWithLabel() throws Exception {
        this.getApplication().setMessageBundle("javax.faces.component.TestMessages");
        HtmlInputText component = new HtmlInputText();
        component.setLabel("hoge");
        component.setId("id");
        DoubleRangeValidator validator = new DoubleRangeValidator();
        validator.setMinimum(1.0);
        try {
            validator.validate((FacesContext)this.getFacesContext(), (UIComponent)component, (Object)new Integer(0));
            DoubleRangeValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            DoubleRangeValidatorTest.assertEquals((String)"less than min(1,hoge)", (String)expected.getMessage());
            DoubleRangeValidatorTest.success();
        }
    }

    public void testValidate_moreThanMaxWhenMaxNotNull() throws Exception {
        FacesContext context = this.getFacesContextWithSetMessageBundle("a", Locale.ENGLISH);
        DoubleRangeValidator validator = new DoubleRangeValidator(10.0);
        try {
            validator.validate(context, (UIComponent)context.getViewRoot(), (Object)new Float(11.0f));
            DoubleRangeValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            DoubleRangeValidatorTest.assertEquals((String)"more than max(10,a)", (String)expected.getMessage());
            DoubleRangeValidatorTest.success();
        }
    }

    public void testValidate_moreThanMaxWhenMaxNotNullWithLabel() throws Exception {
        this.getApplication().setMessageBundle("javax.faces.component.TestMessages");
        HtmlInputText component = new HtmlInputText();
        component.setLabel("hoge");
        component.setId("id");
        DoubleRangeValidator validator = new DoubleRangeValidator(10.0);
        try {
            validator.validate((FacesContext)this.getFacesContext(), (UIComponent)component, (Object)new Float(11.0f));
            DoubleRangeValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            DoubleRangeValidatorTest.assertEquals((String)"more than max(10,hoge)", (String)expected.getMessage());
            DoubleRangeValidatorTest.success();
        }
    }

    public void testValidate_valueIsNotNumber() throws Exception {
        FacesContext context = this.getFacesContextWithSetMessageBundle("hoge", Locale.ENGLISH);
        DoubleRangeValidator validator = new DoubleRangeValidator(10.0);
        try {
            validator.validate(context, (UIComponent)context.getViewRoot(), (Object)"aaa");
            DoubleRangeValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            DoubleRangeValidatorTest.assertEquals((String)"type(hoge) is not double", (String)expected.getMessage());
            DoubleRangeValidatorTest.success();
        }
    }

    public void testValidate_valueIsNotNumberWithLabel() throws Exception {
        this.getApplication().setMessageBundle("javax.faces.component.TestMessages");
        HtmlInputText component = new HtmlInputText();
        component.setLabel("hoge");
        component.setId("id");
        DoubleRangeValidator validator = new DoubleRangeValidator(10.0);
        try {
            validator.validate((FacesContext)this.getFacesContext(), (UIComponent)component, (Object)"aaa");
            DoubleRangeValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            DoubleRangeValidatorTest.assertEquals((String)"type(hoge) is not double", (String)expected.getMessage());
            DoubleRangeValidatorTest.success();
        }
    }

    public void testValidate_NoValidate() throws Exception {
        MockFacesContext context = this.getFacesContext();
        DoubleRangeValidator validator = new DoubleRangeValidator(5.0, 2.0);
        validator.validate((FacesContext)context, (UIComponent)new MockUIComponent(), (Object)"");
    }

    public void testEquals1() throws Exception {
        DoubleRangeValidator v1 = new DoubleRangeValidator(2.0, 1.0);
        DoubleRangeValidator v2 = new DoubleRangeValidator(2.0, 1.0);
        DoubleRangeValidatorTest.assertTrue((boolean)v1.equals((Object)v2));
    }

    public void testEquals2() throws Exception {
        DoubleRangeValidator v1 = new DoubleRangeValidator(1.0);
        DoubleRangeValidator v2 = new DoubleRangeValidator(1.0);
        DoubleRangeValidatorTest.assertTrue((boolean)v1.equals((Object)v2));
    }

    public void testEquals3() throws Exception {
        DoubleRangeValidator v1 = new DoubleRangeValidator();
        DoubleRangeValidator v2 = new DoubleRangeValidator();
        DoubleRangeValidatorTest.assertTrue((boolean)v1.equals((Object)v2));
    }

    public void testEquals4() throws Exception {
        DoubleRangeValidator v1 = new DoubleRangeValidator();
        v1.setMinimum(3.0);
        DoubleRangeValidator v2 = new DoubleRangeValidator();
        v2.setMinimum(3.0);
        DoubleRangeValidatorTest.assertTrue((boolean)v1.equals((Object)v2));
    }

    public void testEquals5() throws Exception {
        DoubleRangeValidator v1 = new DoubleRangeValidator(4.0);
        DoubleRangeValidator v2 = new DoubleRangeValidator();
        DoubleRangeValidatorTest.assertFalse((boolean)v1.equals((Object)v2));
    }

    public void testEquals6() throws Exception {
        DoubleRangeValidator v1 = new DoubleRangeValidator();
        DoubleRangeValidator v2 = new DoubleRangeValidator(6.0);
        DoubleRangeValidatorTest.assertFalse((boolean)v1.equals((Object)v2));
    }

    public void testEquals7() throws Exception {
        DoubleRangeValidator v1 = new DoubleRangeValidator(7.0);
        DoubleRangeValidator v2 = new DoubleRangeValidator(8.0);
        DoubleRangeValidatorTest.assertFalse((boolean)v1.equals((Object)v2));
    }

    public void testEquals8() throws Exception {
        DoubleRangeValidator v1 = new DoubleRangeValidator();
        v1.setMinimum(3.0);
        DoubleRangeValidator v2 = new DoubleRangeValidator();
        DoubleRangeValidatorTest.assertFalse((boolean)v1.equals((Object)v2));
    }

    public void testEquals9() throws Exception {
        DoubleRangeValidator v1 = new DoubleRangeValidator();
        DoubleRangeValidator v2 = new DoubleRangeValidator();
        v2.setMinimum(9.0);
        DoubleRangeValidatorTest.assertFalse((boolean)v1.equals((Object)v2));
    }

    public void testEquals10() throws Exception {
        DoubleRangeValidator v1 = new DoubleRangeValidator(2.0);
        v1.setMinimum(8.0);
        DoubleRangeValidator v2 = new DoubleRangeValidator(2.0);
        v2.setMinimum(9.0);
        DoubleRangeValidatorTest.assertFalse((boolean)v1.equals((Object)v2));
    }

    public void testEquals12() throws Exception {
        DoubleRangeValidator v1 = new DoubleRangeValidator();
        LongRangeValidator v2 = new LongRangeValidator();
        DoubleRangeValidatorTest.assertFalse((boolean)v1.equals((Object)v2));
    }

    protected FacesContext getFacesContextWithSetMessageBundle(String viewRootId, Locale locale) {
        this.getApplication().setMessageBundle("javax.faces.component.TestMessages");
        MockFacesContext context = this.getFacesContext();
        UIViewRoot root = new UIViewRoot();
        root.setId(viewRootId);
        root.setLocale(locale);
        context.setViewRoot(root);
        return context;
    }

    protected Validator createValidator() {
        return new DoubleRangeValidator();
    }
}

