/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.HashMap;
import javax.faces.component.UIComponent;
import javax.faces.internal.ComponentAttributesMap;
import junit.framework.TestCase;
import org.seasar.teeda.core.mock.MockUIComponent;
import org.seasar.teeda.core.unit.ExceptionAssert;

public class ComponentAttributesMapTest
extends TestCase {
    public void testGetComponentProperty() {
        MockUIComponent component = new MockUIComponent();
        component.setFamily("mock");
        ComponentAttributesMap map = new ComponentAttributesMap((UIComponent)component);
        ComponentAttributesMapTest.assertNotNull((Object)map.get((Object)"family"));
        ComponentAttributesMapTest.assertEquals((Object)"mock", (Object)map.get((Object)"family"));
    }

    public void testPutComponentProperty() {
        MockUIComponent component = new MockUIComponent();
        component.setFamily("mock");
        ComponentAttributesMap map = new ComponentAttributesMap((UIComponent)component);
        ComponentAttributesMapTest.assertEquals((Object)"mock", (Object)map.get((Object)"family"));
        component.setFamily("mock2");
        ComponentAttributesMapTest.assertEquals((Object)"mock2", (Object)map.get((Object)"family"));
    }

    public void testRemoveComponentProperty() throws Exception {
        MockUIComponent component = new MockUIComponent();
        component.setFamily("mock");
        ComponentAttributesMap map = new ComponentAttributesMap((UIComponent)component);
        try {
            map.remove((Object)"family");
            ComponentAttributesMapTest.fail();
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public void testContainsKey_ComponentProperty() throws Exception {
        MockUIComponent component = new MockUIComponent();
        component.setFamily("mock");
        ComponentAttributesMap map = new ComponentAttributesMap((UIComponent)component);
        ComponentAttributesMapTest.assertEquals((boolean)false, (boolean)map.containsKey((Object)"family"));
    }

    public void testContainsKey_NotComponentProperty() throws Exception {
        MockUIComponent component = new MockUIComponent();
        component.setFamily("mock");
        ComponentAttributesMap map = new ComponentAttributesMap((UIComponent)component);
        ComponentAttributesMapTest.assertEquals((boolean)false, (boolean)map.containsKey((Object)"aaaa"));
        map.put((Object)"aaaa", (Object)"some value");
        ComponentAttributesMapTest.assertEquals((boolean)true, (boolean)map.containsKey((Object)"aaaa"));
    }

    public void testGetComponentWriteOnlyProperty() {
        MyMockUIComponent component = new MyMockUIComponent();
        ComponentAttributesMap map = new ComponentAttributesMap((UIComponent)component);
        try {
            ComponentAttributesMapTest.assertNull((Object)map.get((Object)"barProperty"));
        }
        catch (IllegalArgumentException iae) {
            ComponentAttributesMapTest.fail();
        }
    }

    public void testPutComponentReadOnlyProperty() {
        MyMockUIComponent component = new MyMockUIComponent();
        ComponentAttributesMap map = new ComponentAttributesMap((UIComponent)component);
        try {
            map.put((Object)"fooProperty", (Object)"some value");
            ComponentAttributesMapTest.assertTrue((map.size() == 1 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            ComponentAttributesMapTest.fail();
        }
    }

    public void testPut_NotComponentProperty() throws Exception {
        MockUIComponent component = new MockUIComponent();
        ComponentAttributesMap map = new ComponentAttributesMap((UIComponent)component);
        map.put((Object)"notUIComponentProperty", (Object)"some value");
        ComponentAttributesMapTest.assertEquals((Object)"some value", (Object)map.get((Object)"notUIComponentProperty"));
    }

    public void testPut_KeyIsNull() throws Exception {
        MockUIComponent c = new MockUIComponent();
        ComponentAttributesMap map = new ComponentAttributesMap((UIComponent)c);
        try {
            map.put(null, new Object());
            ComponentAttributesMapTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public void testPut_ValueIsNull() throws Exception {
        MockUIComponent c = new MockUIComponent();
        ComponentAttributesMap map = new ComponentAttributesMap((UIComponent)c);
        try {
            map.put((Object)"hoge", null);
            ComponentAttributesMapTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public void testPut_KeyShouldBeString() throws Exception {
        MockUIComponent c = new MockUIComponent();
        ComponentAttributesMap map = new ComponentAttributesMap((UIComponent)c);
        try {
            map.put((Object)new Integer(1), (Object)"value");
            ComponentAttributesMapTest.fail();
        }
        catch (ClassCastException cce) {
            ExceptionAssert.assertMessageExist(cce);
        }
    }

    public void testPutAll() throws Exception {
        MockUIComponent c = new MockUIComponent();
        ComponentAttributesMap map = new ComponentAttributesMap((UIComponent)c);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "A");
        map.putAll(m);
        ComponentAttributesMapTest.assertEquals((Object)"A", (Object)map.get((Object)"a"));
    }

    private static class MyMockUIComponent
    extends MockUIComponent {
        private MyMockUIComponent() {
        }

        public String getFooProperty() {
            return "fooValue";
        }

        public void setBarProperty() {
        }
    }
}

