/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.html;

import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputText;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.mock.MockApplicationImpl;
import org.seasar.teeda.core.mock.MockConverter;
import org.seasar.teeda.core.mock.MockMethodBinding;
import org.seasar.teeda.core.taglib.html.InputTextTag;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class InputTextTagTest
extends TeedaTestCase {
    public void testGetComponentType() throws Exception {
        InputTextTag tag = new InputTextTag();
        InputTextTagTest.assertEquals((String)"javax.faces.HtmlInputText", (String)tag.getComponentType());
    }

    public void testGetRenderType() throws Exception {
        InputTextTag tag = new InputTextTag();
        InputTextTagTest.assertEquals((String)"javax.faces.Text", (String)tag.getRendererType());
    }

    public void testSetProperties_All() throws Exception {
        HtmlInputText component = this.createHtmlInputText();
        InputTextTag tag = new InputTextTag();
        MockApplicationImpl app = new MockApplicationImpl();
        app.addConverter("mock.converter", "org.seasar.teeda.core.mock.MockConverter");
        this.setApplication((MockApplication)app);
        app.addValidator("mock.validator", "org.seasar.teeda.core.mock.MockValidator");
        tag.setConverter("mock.converter");
        tag.setImmediate("false");
        tag.setRequired("true");
        tag.setValidator("#{mock.validator}");
        tag.setValue("value");
        tag.setValueChangeListener("#{mock.listener}");
        tag.setAccesskey("accesskey");
        tag.setAlt("alt");
        tag.setDir("dir");
        tag.setDisabled("false");
        tag.setLang("lang");
        tag.setMaxlength("15");
        tag.setOnblur("onblur");
        tag.setOnchange("onchange");
        tag.setOnclick("onclick");
        tag.setOndblclick("ondblclick");
        tag.setOnfocus("onfocus");
        tag.setOnkeydown("onkeydown");
        tag.setOnkeypress("onkeypress");
        tag.setOnkeyup("onkeyup");
        tag.setOnmousedown("onmousedown");
        tag.setOnmousemove("onmousemove");
        tag.setOnmouseout("onmouseout");
        tag.setOnmouseover("onmouseover");
        tag.setOnmouseup("onmouseup");
        tag.setOnselect("onselect");
        tag.setReadonly("true");
        tag.setSize("33");
        tag.setStyle("style");
        tag.setStyleClass("styleclass");
        tag.setTabindex("13");
        tag.setTitle("title");
        tag.setAutocomplete("on");
        tag.setProperties((UIComponent)component);
        InputTextTagTest.assertTrue((boolean)(component.getConverter() instanceof MockConverter));
        InputTextTagTest.assertFalse((boolean)component.isImmediate());
        InputTextTagTest.assertTrue((boolean)component.isRequired());
        InputTextTagTest.assertTrue((boolean)(component.getValidator() instanceof MockMethodBinding));
        InputTextTagTest.assertEquals((String)"#{mock.validator}", (String)component.getValidator().getExpressionString());
        InputTextTagTest.assertEquals((Object)"value", (Object)component.getValue());
        InputTextTagTest.assertTrue((boolean)(component.getValueChangeListener() instanceof MockMethodBinding));
        InputTextTagTest.assertEquals((String)"#{mock.listener}", (String)component.getValueChangeListener().getExpressionString());
        InputTextTagTest.assertEquals((String)"accesskey", (String)component.getAccesskey());
        InputTextTagTest.assertEquals((String)"alt", (String)component.getAlt());
        InputTextTagTest.assertEquals((String)"dir", (String)component.getDir());
        InputTextTagTest.assertFalse((boolean)component.isDisabled());
        InputTextTagTest.assertEquals((String)"lang", (String)component.getLang());
        InputTextTagTest.assertEquals((int)15, (int)component.getMaxlength());
        InputTextTagTest.assertEquals((String)"onblur", (String)component.getOnblur());
        InputTextTagTest.assertEquals((String)"onchange", (String)component.getOnchange());
        InputTextTagTest.assertEquals((String)"onclick", (String)component.getOnclick());
        InputTextTagTest.assertEquals((String)"ondblclick", (String)component.getOndblclick());
        InputTextTagTest.assertEquals((String)"onfocus", (String)component.getOnfocus());
        InputTextTagTest.assertEquals((String)"onkeydown", (String)component.getOnkeydown());
        InputTextTagTest.assertEquals((String)"onkeypress", (String)component.getOnkeypress());
        InputTextTagTest.assertEquals((String)"onkeyup", (String)component.getOnkeyup());
        InputTextTagTest.assertEquals((String)"onmousedown", (String)component.getOnmousedown());
        InputTextTagTest.assertEquals((String)"onmousemove", (String)component.getOnmousemove());
        InputTextTagTest.assertEquals((String)"onmouseout", (String)component.getOnmouseout());
        InputTextTagTest.assertEquals((String)"onmouseover", (String)component.getOnmouseover());
        InputTextTagTest.assertEquals((String)"onmouseup", (String)component.getOnmouseup());
        InputTextTagTest.assertEquals((String)"onselect", (String)component.getOnselect());
        InputTextTagTest.assertTrue((boolean)component.isReadonly());
        InputTextTagTest.assertEquals((int)33, (int)component.getSize());
        InputTextTagTest.assertEquals((String)"style", (String)component.getStyle());
        InputTextTagTest.assertEquals((String)"styleclass", (String)component.getStyleClass());
        InputTextTagTest.assertEquals((String)"13", (String)component.getTabindex());
        InputTextTagTest.assertEquals((String)"title", (String)component.getTitle());
        InputTextTagTest.assertEquals((String)"on", (String)component.getAutocomplete());
    }

    public void testRelease() throws Exception {
        InputTextTag tag = new InputTextTag();
        tag.setImmediate("true");
        tag.setRequired("true");
        tag.setValidator("hoge");
        tag.setValueChangeListener("#{mock.listener}");
        tag.setReadonly("true");
        tag.setAutocomplete("off");
        tag.release();
        InputTextTagTest.assertEquals(null, (String)tag.getImmediate());
        InputTextTagTest.assertEquals(null, (String)tag.getRequired());
        InputTextTagTest.assertEquals(null, (String)tag.getValidator());
        InputTextTagTest.assertEquals(null, (String)tag.getValueChangeListener());
        InputTextTagTest.assertEquals(null, (String)tag.getReadonly());
        InputTextTagTest.assertEquals(null, (String)tag.getAutocomplete());
    }

    private HtmlInputText createHtmlInputText() {
        return (HtmlInputText)this.createUIComponent();
    }

    protected UIComponent createUIComponent() {
        return new HtmlInputText();
    }
}

