/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlMessages;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.render.html.HtmlMessagesRenderer;

public class HtmlMessagesRendererTest
extends RendererTest {
    private HtmlMessagesRenderer renderer;
    private MockHtmlMessages htmlMessages;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlMessagesRenderer();
        this.htmlMessages = new MockHtmlMessages();
        this.htmlMessages.setRenderer((Renderer)this.renderer);
    }

    public void testEncode_NoMessage() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_NoMessageValue_List() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        context.addMessage(null, facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li></li></ul>", (String)this.getResponseText());
    }

    public void testEncode_Summary1() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        context.addMessage(null, facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li>s</li></ul>", (String)this.getResponseText());
    }

    public void testEncode_Summary1_NoEscape() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("<s>");
        context.addMessage(null, facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li><s></li></ul>", (String)this.getResponseText());
    }

    public void testEncode_Summary1_table() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        context.addMessage(null, facesMessage);
        this.htmlMessages.setLayout("table");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<table><tr><td>s</td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_Summary2() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s1");
        context.addMessage(null, facesMessage);
        facesMessage = new FacesMessage();
        facesMessage.setSummary("s2");
        context.addMessage("aaa", facesMessage);
        this.htmlMessages.setLayout("list");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li>s1</li><li>s2</li></ul>", (String)this.getResponseText());
    }

    public void testEncode_Summary2_table() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s1");
        context.addMessage(null, facesMessage);
        facesMessage = new FacesMessage();
        facesMessage.setSummary("s2");
        context.addMessage("aaa", facesMessage);
        this.htmlMessages.setLayout("table");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<table><tr><td>s1</td></tr><tr><td>s2</td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_globalOnly() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s1");
        context.addMessage("aaa", facesMessage);
        facesMessage = new FacesMessage();
        facesMessage.setSummary("s2");
        context.addMessage(null, facesMessage);
        facesMessage = new FacesMessage();
        facesMessage.setSummary("s3");
        context.addMessage(null, facesMessage);
        this.htmlMessages.setGlobalOnly(true);
        this.htmlMessages.setLayout("table");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<table><tr><td>s2</td></tr><tr><td>s3</td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_Detail() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.htmlMessages.setShowSummary(false);
        this.htmlMessages.setShowDetail(true);
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        facesMessage.setDetail("d");
        context.addMessage(null, facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li>d</li></ul>", (String)this.getResponseText());
    }

    public void testEncode_Detail_Escape() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.htmlMessages.setShowSummary(false);
        this.htmlMessages.setShowDetail(true);
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("<d>");
        context.addMessage(null, facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li><d></li></ul>", (String)this.getResponseText());
    }

    public void testEncode_SummaryAndDetail() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.htmlMessages.setShowSummary(true);
        this.htmlMessages.setShowDetail(true);
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        facesMessage.setDetail("d");
        context.addMessage("a", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li>s d</li></ul>", (String)this.getResponseText());
    }

    public void testEncode_SummaryAndDetail_NoEscape() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.htmlMessages.setShowSummary(true);
        this.htmlMessages.setShowDetail(true);
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("<s>");
        facesMessage.setDetail("<d>");
        context.addMessage("a", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li><s> <d></li></ul>", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlMessages.setRendered(false);
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        facesMessage.setDetail("d");
        context.addMessage("w", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_Id() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.htmlMessages.setId("ab");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        context.addMessage("foo", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul id=\"ab\"><li>s</li></ul>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute1() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.htmlMessages.getAttributes().put("abc", "ABC");
        this.htmlMessages.getAttributes().put("a.b", "AAA");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        context.addMessage("foo", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li><span abc=\"ABC\">s</span></li></ul>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute2() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.htmlMessages.getAttributes().put("a.b", "AAA");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        context.addMessage("foo", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li>s</li></ul>", (String)this.getResponseText());
    }

    public void testEncode_Id_table() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.htmlMessages.setId("ab");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        context.addMessage("foo", facesMessage);
        this.htmlMessages.setLayout("table");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<table id=\"ab\"><tr><td>s</td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_InfoStyle() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        facesMessage.setSeverity(FacesMessage.SEVERITY_INFO);
        context.addMessage("foo", facesMessage);
        this.htmlMessages.setInfoStyle("aaa");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li><span style=\"aaa\">s</span></li></ul>", (String)this.getResponseText());
    }

    public void testEncode_InfoClass() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        facesMessage.setSeverity(FacesMessage.SEVERITY_INFO);
        context.addMessage("foo", facesMessage);
        this.htmlMessages.setInfoClass("bb");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li><span class=\"bb\">s</span></li></ul>", (String)this.getResponseText());
    }

    public void testEncode_StyleClassAndWarnStyle() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        facesMessage.setSeverity(FacesMessage.SEVERITY_WARN);
        context.addMessage("foo", facesMessage);
        this.htmlMessages.setStyle("ss");
        this.htmlMessages.setWarnClass("tt");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li><span style=\"ss\" class=\"tt\">s</span></li></ul>", (String)this.getResponseText());
    }

    public void testEncode_ErrorStyleAndStyleClass() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
        context.addMessage("foo", facesMessage);
        this.htmlMessages.setErrorStyle("ee");
        this.htmlMessages.setStyleClass("ss");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li><span style=\"ee\" class=\"ss\">s</span></li></ul>", (String)this.getResponseText());
    }

    public void testEncode_InfoStyleAndInfoClass() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        facesMessage.setSeverity(FacesMessage.SEVERITY_INFO);
        context.addMessage("foo", facesMessage);
        this.arrangeStyles(this.htmlMessages);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li><span style=\"is\" class=\"ic\">s</span></li></ul>", (String)this.getResponseText());
    }

    public void testEncode_WarnStyleAndWarnClass() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        facesMessage.setSeverity(FacesMessage.SEVERITY_WARN);
        context.addMessage("foo", facesMessage);
        this.arrangeStyles(this.htmlMessages);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li><span style=\"ws\" class=\"wc\">s</span></li></ul>", (String)this.getResponseText());
    }

    public void testEncode_ErrorStyleAndErrorClass() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
        context.addMessage("foo", facesMessage);
        this.arrangeStyles(this.htmlMessages);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li><span style=\"es\" class=\"ec\">s</span></li></ul>", (String)this.getResponseText());
    }

    public void testEncode_FatalStyleAndFatalClass() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        facesMessage.setSeverity(FacesMessage.SEVERITY_FATAL);
        context.addMessage("foo", facesMessage);
        this.arrangeStyles(this.htmlMessages);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li><span style=\"fs\" class=\"fc\">s</span></li></ul>", (String)this.getResponseText());
    }

    public void testEncode_FatalStyleAndFatalClass_table() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        facesMessage.setSeverity(FacesMessage.SEVERITY_FATAL);
        context.addMessage("foo", facesMessage);
        this.arrangeStyles(this.htmlMessages);
        this.htmlMessages.setLayout("table");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<table><tr><td><span style=\"fs\" class=\"fc\">s</span></td></tr></table>", (String)this.getResponseText());
    }

    public void testEncode_StyleAndStyleClass() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        context.addMessage(null, facesMessage);
        this.htmlMessages.setStyle("s1");
        this.htmlMessages.setStyleClass("s2");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li><span style=\"s1\" class=\"s2\">s</span></li></ul>", (String)this.getResponseText());
    }

    private void arrangeStyles(HtmlMessages htmlMessages) {
        htmlMessages.setInfoClass("ic");
        htmlMessages.setInfoStyle("is");
        htmlMessages.setWarnClass("wc");
        htmlMessages.setWarnStyle("ws");
        htmlMessages.setErrorClass("ec");
        htmlMessages.setErrorStyle("es");
        htmlMessages.setFatalClass("fc");
        htmlMessages.setFatalStyle("fs");
        htmlMessages.setStyle("s");
        htmlMessages.setStyleClass("sc");
    }

    public void testEncode_Title() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        context.addMessage("foo", facesMessage);
        this.htmlMessages.setTitle("t");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li><span title=\"t\">s</span></li></ul>", (String)this.getResponseText());
    }

    public void testEncode_Tooltip() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        facesMessage.setDetail("d");
        context.addMessage("foo", facesMessage);
        this.htmlMessages.setTooltip(true);
        this.htmlMessages.setShowDetail(true);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"<ul><li><span title=\"s\">d</span></li></ul>", (String)this.getResponseText());
    }

    public void testEncode_TitleAndTooltip() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        facesMessage.setDetail("d");
        context.addMessage("bar", facesMessage);
        this.htmlMessages.setTitle("t");
        this.htmlMessages.setTooltip(true);
        this.htmlMessages.setShowDetail(true);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessages);
        HtmlMessagesRendererTest.assertEquals((String)"prioritize [tooltip] over [title]", (String)"<ul><li><span title=\"s\">d</span></li></ul>", (String)this.getResponseText());
    }

    public void testGetRendersChildren() throws Exception {
        HtmlMessagesRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlMessagesRenderer createHtmlMessagesRenderer() {
        return (HtmlMessagesRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlMessagesRenderer renderer = new HtmlMessagesRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }

    private static class MockHtmlMessages
    extends HtmlMessages {
        private Renderer renderer_;
        private String clientId_;

        private MockHtmlMessages() {
        }

        public void setRenderer(Renderer renderer) {
            this.renderer_ = renderer;
        }

        protected Renderer getRenderer(FacesContext context) {
            if (this.renderer_ != null) {
                return this.renderer_;
            }
            return super.getRenderer(context);
        }

        public String getClientId(FacesContext context) {
            if (this.clientId_ != null) {
                return this.clientId_;
            }
            return super.getClientId(context);
        }

        public void setClientId(String clientId) {
            this.clientId_ = clientId;
        }
    }
}

