/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.internal.FacesConfigOptions;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import javax.servlet.ServletContext;
import junitx.framework.ObjectAssert;
import org.custommonkey.xmlunit.Diff;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockHttpServletRequestImpl;
import org.seasar.framework.mock.servlet.MockServletContextImpl;
import org.seasar.teeda.core.exception.TagNotFoundRuntimeException;
import org.seasar.teeda.core.mock.MockExternalContext;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlCommandLink;
import org.seasar.teeda.core.mock.MockHtmlForm;
import org.seasar.teeda.core.mock.MockMethodBinding;
import org.seasar.teeda.core.render.html.HtmlCommandLinkRenderer;
import org.seasar.teeda.core.render.html.HtmlFormRenderer;
import org.seasar.teeda.core.unit.ExceptionAssert;

public class HtmlCommandLinkRendererTest
extends RendererTest {
    private HtmlCommandLinkRenderer renderer;
    private MockHtmlCommandLink htmlCommandLink;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlCommandLinkRenderer();
        this.htmlCommandLink = new MockHtmlCommandLink();
        this.htmlCommandLink.setRenderer((Renderer)this.renderer);
    }

    public void testNoParentForm() throws Exception {
        try {
            this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandLink);
            HtmlCommandLinkRendererTest.fail();
        }
        catch (TagNotFoundRuntimeException e) {
            ExceptionAssert.assertMessageExist(e);
        }
    }

    public void testEncode_NoValue() throws Exception {
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("a");
        form.getChildren().add(this.htmlCommandLink);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandLink);
        MockFacesContext context = this.getFacesContext();
        HtmlCommandLinkRendererTest.assertEquals((String)"a", (String)form.getClientId((FacesContext)context));
        HtmlCommandLinkRendererTest.assertEquals((String)"<a href=\"#\" onclick=\"clear_a();var f = document.forms['a']; f['a:__link_clicked__'].value = 'a:_id0'; if (f.onsubmit) { f.onsubmit(); } f.submit();clear_a(); return false;\"></a>", (String)this.getResponseText());
    }

    public void testEncode_withOnclick() throws Exception {
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("a");
        form.getChildren().add(this.htmlCommandLink);
        this.htmlCommandLink.setOnclick("hoge();");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandLink);
        MockFacesContext context = this.getFacesContext();
        HtmlCommandLinkRendererTest.assertEquals((String)"a", (String)form.getClientId((FacesContext)context));
        HtmlCommandLinkRendererTest.assertEquals((String)"<a href=\"#\" onclick=\"hoge();clear_a();var f = document.forms['a']; f['a:__link_clicked__'].value = 'a:_id0'; if (f.onsubmit) { f.onsubmit(); } f.submit();clear_a(); return false;\"></a>", (String)this.getResponseText());
    }

    public void testEncode_WithValue() throws Exception {
        this.htmlCommandLink.setValue("abc");
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("b");
        form.getChildren().add(this.htmlCommandLink);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandLink);
        HtmlCommandLinkRendererTest.assertEquals((String)"<a href=\"#\" onclick=\"clear_b();var f = document.forms['b']; f['b:__link_clicked__'].value = 'b:_id0'; if (f.onsubmit) { f.onsubmit(); } f.submit();clear_b(); return false;\">abc</a>", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlCommandLink.setRendered(false);
        this.htmlCommandLink.setValue("abc");
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("c");
        form.getChildren().add(this.htmlCommandLink);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandLink);
        HtmlCommandLinkRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_WithId() throws Exception {
        this.htmlCommandLink.setId("a");
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("b");
        form.getChildren().add(this.htmlCommandLink);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandLink);
        HtmlCommandLinkRendererTest.assertEquals((String)"<a id=\"a\" href=\"#\" onclick=\"clear_b();var f = document.forms['b']; f['b:__link_clicked__'].value = 'b:a'; if (f.onsubmit) { f.onsubmit(); } f.submit();clear_b(); return false;\"></a>", (String)this.getResponseText());
    }

    public void testEncode_WithParameter() throws Exception {
        this.htmlCommandLink.setId("a");
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("b");
        form.getChildren().add(this.htmlCommandLink);
        UIParameter param = new UIParameter();
        param.setName("c");
        param.setValue((Object)"1");
        this.htmlCommandLink.getChildren().add(param);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandLink);
        HtmlCommandLinkRendererTest.assertEquals((String)"<a id=\"a\" href=\"#\" onclick=\"clear_b();var f = document.forms['b']; f['b:__link_clicked__'].value = 'b:a'; f['c'].value = '1'; if (f.onsubmit) { f.onsubmit(); } f.submit();clear_b(); return false;\"></a>", (String)this.getResponseText());
    }

    public void testEncode_WithParameters() throws Exception {
        this.htmlCommandLink.setId("a");
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("b");
        form.getChildren().add(this.htmlCommandLink);
        UIParameter param = new UIParameter();
        param.setName("c");
        param.setValue((Object)"1");
        this.htmlCommandLink.getChildren().add(param);
        param = new UIParameter();
        param.setName("d");
        param.setValue((Object)"2");
        this.htmlCommandLink.getChildren().add(param);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandLink);
        HtmlCommandLinkRendererTest.assertEquals((String)"<a id=\"a\" href=\"#\" onclick=\"clear_b();var f = document.forms['b']; f['b:__link_clicked__'].value = 'b:a'; f['c'].value = '1'; f['d'].value = '2'; if (f.onsubmit) { f.onsubmit(); } f.submit();clear_b(); return false;\"></a>", (String)this.getResponseText());
    }

    public void testEncode_WithNullParameter() throws Exception {
        this.htmlCommandLink.setId("a");
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("b");
        form.getChildren().add(this.htmlCommandLink);
        UIParameter param = new UIParameter();
        param.setName("c");
        param.setValue(null);
        this.htmlCommandLink.getChildren().add(param);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandLink);
        HtmlCommandLinkRendererTest.assertEquals((String)"<a id=\"a\" href=\"#\" onclick=\"clear_b();var f = document.forms['b']; f['b:__link_clicked__'].value = 'b:a'; f['c'].value = 'null'; if (f.onsubmit) { f.onsubmit(); } f.submit();clear_b(); return false;\"></a>", (String)this.getResponseText());
    }

    public void testEncode_IgnoreAttributes() throws Exception {
        this.htmlCommandLink.setId("aaa");
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("b");
        form.getChildren().add(this.htmlCommandLink);
        this.htmlCommandLink.setAction((MethodBinding)new MockMethodBinding());
        this.htmlCommandLink.setImmediate(true);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandLink);
        HtmlCommandLinkRendererTest.assertEquals((String)"<a id=\"aaa\" href=\"#\" onclick=\"clear_b();var f = document.forms['b']; f['b:__link_clicked__'].value = 'b:aaa'; if (f.onsubmit) { f.onsubmit(); } f.submit();clear_b(); return false;\"></a>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute() throws Exception {
        this.htmlCommandLink.setValue("abc");
        this.htmlCommandLink.getAttributes().put("c", "d");
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("b");
        form.getChildren().add(this.htmlCommandLink);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandLink);
        HtmlCommandLinkRendererTest.assertEquals((String)"<a href=\"#\" onclick=\"clear_b();var f = document.forms['b']; f['b:__link_clicked__'].value = 'b:_id0'; if (f.onsubmit) { f.onsubmit(); } f.submit();clear_b(); return false;\" c=\"d\">abc</a>", (String)this.getResponseText());
    }

    public void testEncode_WithTarget() throws Exception {
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("frm");
        form.getChildren().add(this.htmlCommandLink);
        this.htmlCommandLink.setTarget("_blank");
        this.htmlCommandLink.setId("x");
        this.htmlCommandLink.setValue("aaa");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandLink);
        HtmlCommandLinkRendererTest.assertEquals((String)"<a id=\"x\" href=\"#\" onclick=\"clear_frm();var f = document.forms['frm']; f['frm:__link_clicked__'].value = 'frm:x'; f.target = '_blank'; if (f.onsubmit) { f.onsubmit(); } f.submit();clear_frm(); return false;\" target=\"_blank\">aaa</a>", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("zz");
        form.getChildren().add(this.htmlCommandLink);
        this.htmlCommandLink.setAccesskey("a");
        this.htmlCommandLink.setCharset("b");
        this.htmlCommandLink.setCoords("c");
        this.htmlCommandLink.setDir("d");
        this.htmlCommandLink.setHreflang("e");
        this.htmlCommandLink.setLang("f");
        this.htmlCommandLink.setOnblur("g");
        this.htmlCommandLink.setOnclick("h");
        this.htmlCommandLink.setOndblclick("i");
        this.htmlCommandLink.setOnfocus("j");
        this.htmlCommandLink.setOnkeydown("k");
        this.htmlCommandLink.setOnkeypress("l");
        this.htmlCommandLink.setOnkeyup("m");
        this.htmlCommandLink.setOnmousedown("n");
        this.htmlCommandLink.setOnmousemove("o");
        this.htmlCommandLink.setOnmouseout("p");
        this.htmlCommandLink.setOnmouseover("q");
        this.htmlCommandLink.setOnmouseup("r");
        this.htmlCommandLink.setRel("s");
        this.htmlCommandLink.setRev("t");
        this.htmlCommandLink.setShape("u");
        this.htmlCommandLink.setStyle("v");
        this.htmlCommandLink.setStyleClass("w");
        this.htmlCommandLink.setTabindex("x");
        this.htmlCommandLink.setTarget("y");
        this.htmlCommandLink.setTitle("z");
        this.htmlCommandLink.setType("1");
        this.htmlCommandLink.setId("A");
        this.htmlCommandLink.setValue("B");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandLink);
        Diff diff = new Diff("<a id=\"A\" href=\"#\" onclick=\"h;clear_zz();var f = document.forms['zz']; f['zz:__link_clicked__'].value = 'zz:A'; f.target = 'y'; if (f.onsubmit) { f.onsubmit(); } f.submit();clear_zz(); return false;\" accesskey=\"a\" charset=\"b\" coords=\"c\" dir=\"d\" hreflang=\"e\" lang=\"f\" onblur=\"g\" ondblclick=\"i\" onfocus=\"j\" onkeydown=\"k\" onkeypress=\"l\" onkeyup=\"m\" onmousedown=\"n\" onmousemove=\"o\" onmouseout=\"p\" onmouseover=\"q\" onmouseup=\"r\" rel=\"s\" rev=\"t\" shape=\"u\" style=\"v\" class=\"w\" tabindex=\"x\" target=\"y\" title=\"z\" type=\"1\">B</a>", this.getResponseText());
        HtmlCommandLinkRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testEncode_WithoutJavascript() throws Exception {
        this.htmlCommandLink.setId("hoge");
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("foo");
        form.getChildren().add(this.htmlCommandLink);
        UIParameter param = new UIParameter();
        param.setName("bar");
        param.setValue((Object)"1111");
        this.htmlCommandLink.getChildren().add(param);
        this.htmlCommandLink.setValue("value");
        MockFacesContext context = this.getFacesContext();
        MockExternalContext extContext = (MockExternalContext)context.getExternalContext();
        MockHttpServletRequestImpl request = new MockHttpServletRequestImpl((ServletContext)new MockServletContextImpl("hoge"), "/faces");
        request.setPathInfo("/no_allow_js/aaa");
        extContext.setMockHttpServletRequest((MockHttpServletRequest)request);
        FacesConfigOptions.setJavascriptNotPermittedPath((String[])new String[]{"/no_allow_js"});
        UIViewRoot root = new UIViewRoot();
        root.setViewId("/baz");
        context.setViewRoot(root);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandLink);
        HtmlCommandLinkRendererTest.assertEquals((String)"<a id=\"hoge\" href=\"/baz?foo/baz=foo/baz&amp;foo%3A__link_clicked__=foo%3Ahoge&amp;bar=1111\">value</a>", (String)this.getResponseText());
    }

    public void testDecode_NoEntry() throws Exception {
        final FacesEvent[] args = new FacesEvent[]{null};
        MockHtmlCommandLink htmlCommandLink = new MockHtmlCommandLink(){

            public void queueEvent(FacesEvent event) {
                args[0] = event;
            }
        };
        htmlCommandLink.setRenderer((Renderer)this.renderer);
        htmlCommandLink.setClientId("linkClientId");
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("formId");
        form.getChildren().add(htmlCommandLink);
        MockFacesContext context = this.getFacesContext();
        this.renderer.decode((FacesContext)context, (UIComponent)htmlCommandLink);
        HtmlCommandLinkRendererTest.assertEquals(null, (Object)args[0]);
    }

    public void testDecode_EmptyStringEntry() throws Exception {
        final FacesEvent[] args = new FacesEvent[]{null};
        MockHtmlCommandLink htmlCommandLink = new MockHtmlCommandLink(){

            public void queueEvent(FacesEvent event) {
                args[0] = event;
            }
        };
        htmlCommandLink.setRenderer((Renderer)this.renderer);
        htmlCommandLink.setClientId("linkClientId");
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("formId");
        form.getChildren().add(htmlCommandLink);
        MockFacesContext context = this.getFacesContext();
        String hiddenFieldName = "formId:__link_clicked__";
        context.getExternalContext().getRequestParameterMap().put(hiddenFieldName, "");
        this.renderer.decode((FacesContext)context, (UIComponent)htmlCommandLink);
        HtmlCommandLinkRendererTest.assertEquals(null, (Object)args[0]);
    }

    public void testDecode_DifferentEntry() throws Exception {
        final FacesEvent[] args = new FacesEvent[]{null};
        MockHtmlCommandLink htmlCommandLink = new MockHtmlCommandLink(){

            public void queueEvent(FacesEvent event) {
                args[0] = event;
            }
        };
        htmlCommandLink.setRenderer((Renderer)this.renderer);
        htmlCommandLink.setClientId("linkClientId");
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("formId");
        form.getChildren().add(htmlCommandLink);
        MockFacesContext context = this.getFacesContext();
        String hiddenFieldName = "formId:__link_clicked__";
        context.getExternalContext().getRequestParameterMap().put(hiddenFieldName, "NoCommandLinkClientId");
        this.renderer.decode((FacesContext)context, (UIComponent)htmlCommandLink);
        HtmlCommandLinkRendererTest.assertEquals(null, (Object)args[0]);
    }

    public void testDecode_Success() throws Exception {
        final FacesEvent[] args = new FacesEvent[]{null};
        MockHtmlCommandLink htmlCommandLink = new MockHtmlCommandLink(){

            public void queueEvent(FacesEvent event) {
                args[0] = event;
            }
        };
        htmlCommandLink.setRenderer((Renderer)this.renderer);
        htmlCommandLink.setClientId("linkClientId");
        MockHtmlForm form = new MockHtmlForm();
        form.setRenderer((Renderer)new HtmlFormRenderer());
        form.setId("formId");
        form.getChildren().add(htmlCommandLink);
        MockFacesContext context = this.getFacesContext();
        String hiddenFieldName = "formId:__link_clicked__";
        context.getExternalContext().getRequestParameterMap().put(hiddenFieldName, "linkClientId");
        this.renderer.decode((FacesContext)context, (UIComponent)htmlCommandLink);
        ObjectAssert.assertInstanceOf((Class)ActionEvent.class, (Object)args[0]);
        HtmlCommandLinkRendererTest.assertSame((Object)((Object)htmlCommandLink), (Object)args[0].getSource());
    }

    public void testGetRendersChildren() throws Exception {
        HtmlCommandLinkRendererTest.assertEquals((boolean)true, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlCommandLinkRenderer createHtmlCommandLinkRenderer() {
        return (HtmlCommandLinkRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlCommandLinkRenderer renderer = new HtmlCommandLinkRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }
}

