/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.lifecycle.impl;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.seasar.teeda.core.lifecycle.impl.RenderResponsePhase;
import org.seasar.teeda.core.mock.MockUIViewRoot;
import org.seasar.teeda.core.mock.MockViewHandlerImpl;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class RenderResponsePhaseTest
extends TeedaTestCase {
    public void testGetCurrentPhaseId() throws Exception {
        RenderResponsePhaseTest.assertEquals((Object)PhaseId.RENDER_RESPONSE, (Object)new RenderResponsePhase().getCurrentPhaseId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecutePhase_renderViewSuccess() throws Exception {
        ViewHandler orgHandler = this.getApplication().getViewHandler();
        try {
            MockArgsStoreViewHandler handler = new MockArgsStoreViewHandler();
            this.getApplication().setViewHandler((ViewHandler)handler);
            MockUIViewRoot root = new MockUIViewRoot();
            root.setId("aaa");
            this.getFacesContext().setViewRoot((UIViewRoot)root);
            RenderResponsePhase phase = new RenderResponsePhase();
            phase.executePhase((FacesContext)this.getFacesContext());
            RenderResponsePhaseTest.assertEquals((Object)this.getFacesContext(), (Object)handler.getContext());
            RenderResponsePhaseTest.assertEquals((String)root.getId(), (String)handler.getViewToRender().getId());
        }
        finally {
            this.getApplication().setViewHandler(orgHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecutePhase_renderViewThrowIOException() throws Exception {
        ViewHandler orgHandler = this.getApplication().getViewHandler();
        try {
            MockThrowIOExceptionViewHandler handler = new MockThrowIOExceptionViewHandler();
            this.getApplication().setViewHandler((ViewHandler)handler);
            RenderResponsePhase phase = new RenderResponsePhase();
            phase.executePhase((FacesContext)this.getFacesContext());
            RenderResponsePhaseTest.fail();
        }
        catch (FacesException expected) {
            RenderResponsePhaseTest.assertTrue((boolean)(expected.getCause() instanceof IOException));
            IOException e = (IOException)expected.getCause();
            RenderResponsePhaseTest.assertEquals((String)"hoge", (String)e.getMessage());
            RenderResponsePhaseTest.success();
        }
        finally {
            this.getApplication().setViewHandler(orgHandler);
        }
    }

    private static class MockThrowIOExceptionViewHandler
    extends MockViewHandlerImpl {
        private MockThrowIOExceptionViewHandler() {
        }

        public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
            throw new IOException("hoge");
        }
    }

    private static class MockArgsStoreViewHandler
    extends MockViewHandlerImpl {
        private FacesContext context_;
        private UIViewRoot viewToRender_;

        private MockArgsStoreViewHandler() {
        }

        public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
            this.context_ = context;
            this.viewToRender_ = viewToRender;
        }

        public FacesContext getContext() {
            return this.context_;
        }

        public UIViewRoot getViewToRender() {
            return this.viewToRender_;
        }
    }
}

