/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.faces.FacesException;
import org.seasar.framework.exception.IllegalAccessRuntimeException;
import org.seasar.framework.exception.InstantiationRuntimeException;
import org.seasar.framework.exception.InvocationTargetRuntimeException;
import org.seasar.framework.util.ClassUtil;

public class MarshalUtil {
    public static Object createMarshalInstance(String className, Class beforeClass, Object current) {
        return MarshalUtil.createMarshalInstance(ClassUtil.forName((String)className), beforeClass, current);
    }

    public static Object createMarshalInstance(Class clazz, Class beforeClass, Object current) {
        if (clazz == null) {
            if (current == null) {
                throw new IllegalArgumentException();
            }
            return current;
        }
        Constructor constructor = MarshalUtil.getConstructorWithNoException(clazz, new Class[]{beforeClass});
        current = constructor != null ? MarshalUtil.newInstanceByConstructor(constructor, new Object[]{current}) : ClassUtil.newInstance((Class)clazz);
        return current;
    }

    public static Constructor getConstructorWithNoException(Class clazz, Class[] argTypes) {
        if (clazz == null || argTypes == null) {
            throw new IllegalArgumentException();
        }
        try {
            return clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Object newInstanceByConstructor(Constructor constructor, Object[] args) {
        if (constructor == null || args == null) {
            throw new IllegalArgumentException();
        }
        try {
            return constructor.newInstance(args);
        }
        catch (IllegalArgumentException e) {
            throw new FacesException(e);
        }
        catch (InstantiationException e) {
            throw new InstantiationRuntimeException(constructor.getClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(constructor.getClass(), e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(constructor.getClass(), e);
        }
    }
}

