/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.ajax.autoregister;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentCustomizer;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.impl.MetaDefImpl;

public class AjaxComponentCustomizer
implements ComponentCustomizer {
    private List methodNames = new ArrayList();

    public AjaxComponentCustomizer() {
        this.addMethodPattern("ajaxAction");
    }

    public void customize(ComponentDef componentDef) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)componentDef.getComponentClass());
        String[] names = beanDesc.getMethodNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (!this.isMatch(name)) continue;
            componentDef.addMetaDef((MetaDef)new MetaDefImpl("teeda-ajax"));
        }
    }

    public void addMethodPattern(String methodName) {
        Pattern pattern = Pattern.compile(methodName);
        this.methodNames.add(pattern);
    }

    protected boolean isMatch(String name) {
        Iterator itr = this.methodNames.iterator();
        while (itr.hasNext()) {
            Pattern pattern = (Pattern)itr.next();
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }
}

