/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import javax.faces.context.FacesContext;
import javax.faces.el.VariableResolver;
import org.seasar.teeda.core.mock.MockVariableResolver;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.VariableResolverUtil;

public class VariableResolverUtilTest
extends TeedaTestCase {
    public void testResolveVariable() {
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("hoge", (Object)"foo");
        Object value = VariableResolverUtil.resolveVariable((FacesContext)this.getFacesContext(), (String)"hoge");
        VariableResolverUtilTest.assertEquals((Object)"foo", (Object)value);
    }

    public void testGetDefaultScopeMap() {
        MockVariableResolver resolver = this.getVariableResolver();
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("key", "value");
        resolver.putValue("requestScope", reqMap);
        Map value = VariableResolverUtil.getDefaultScopeMap((FacesContext)this.getFacesContext(), (VariableResolver)resolver, (String)"key");
        VariableResolverUtilTest.assertNotNull((Object)value);
        VariableResolverUtilTest.assertTrue((boolean)(value instanceof HashMap));
        VariableResolverUtilTest.assertTrue((boolean)value.containsKey("key"));
        WeakHashMap<String, String> sessionMap = new WeakHashMap<String, String>();
        sessionMap.put("key2", "value2");
        resolver.putValue("sessionScope", sessionMap);
        value = VariableResolverUtil.getDefaultScopeMap((FacesContext)this.getFacesContext(), (VariableResolver)resolver, (String)"key2");
        VariableResolverUtilTest.assertNotNull((Object)value);
        VariableResolverUtilTest.assertTrue((boolean)(value instanceof WeakHashMap));
        VariableResolverUtilTest.assertTrue((boolean)value.containsKey("key2"));
        Hashtable<String, String> appMap = new Hashtable<String, String>();
        appMap.put("key3", "value3");
        resolver.putValue("applicationScope", appMap);
        value = VariableResolverUtil.getDefaultScopeMap((FacesContext)this.getFacesContext(), (VariableResolver)resolver, (String)"key3");
        VariableResolverUtilTest.assertNotNull((Object)value);
        VariableResolverUtilTest.assertTrue((boolean)(value instanceof Hashtable));
        VariableResolverUtilTest.assertTrue((boolean)value.containsKey("key3"));
    }
}

