/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import javax.faces.context.FacesContext;
import javax.faces.internal.FacesConfigOptions;
import org.seasar.teeda.core.mock.MockExternalContext;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.JavaScriptPermissionUtil;

public class JavaScriptPermissionUtilTest
extends TeedaTestCase {
    public void testNotPermitted1() throws Exception {
        MockExternalContext context = this.getExternalContext();
        context.setRequestPathInfo("/i/hoge");
        FacesConfigOptions.setJavascriptNotPermittedPath((String[])new String[]{"/i", "/vf", "/au"});
        JavaScriptPermissionUtilTest.assertFalse((boolean)JavaScriptPermissionUtil.isJavaScriptPermitted((FacesContext)this.getFacesContext()));
    }

    public void testNotPermitted2() throws Exception {
        MockExternalContext context = this.getExternalContext();
        context.setRequestPathInfo("/i/hoge");
        FacesConfigOptions.setJavascriptNotPermittedPath((String[])new String[]{" /i/", "/vf", "/au"});
        JavaScriptPermissionUtilTest.assertFalse((boolean)JavaScriptPermissionUtil.isJavaScriptPermitted((FacesContext)this.getFacesContext()));
    }

    public void testNotPermitted3() throws Exception {
        MockExternalContext context = this.getExternalContext();
        context.setRequestPathInfo("/i/hoge");
        FacesConfigOptions.setJavascriptNotPermittedPath((String[])new String[]{" i", "/vf", "/au"});
        JavaScriptPermissionUtilTest.assertFalse((boolean)JavaScriptPermissionUtil.isJavaScriptPermitted((FacesContext)this.getFacesContext()));
    }

    public void testNotPermitted5() throws Exception {
        MockExternalContext context = this.getExternalContext();
        context.setRequestPathInfo(null);
        FacesConfigOptions.setJavascriptNotPermittedPath((String[])new String[]{"/"});
        JavaScriptPermissionUtilTest.assertFalse((boolean)JavaScriptPermissionUtil.isJavaScriptPermitted((FacesContext)this.getFacesContext()));
    }

    public void testPermitted1() throws Exception {
        MockExternalContext context = this.getExternalContext();
        context.setRequestPathInfo("/i/hoge");
        FacesConfigOptions.setJavascriptNotPermittedPath(null);
        JavaScriptPermissionUtilTest.assertTrue((boolean)JavaScriptPermissionUtil.isJavaScriptPermitted((FacesContext)this.getFacesContext()));
    }

    public void testPermitted2() throws Exception {
        MockExternalContext context = this.getExternalContext();
        context.setRequestPathInfo(null);
        FacesConfigOptions.setJavascriptNotPermittedPath((String[])new String[]{"/i"});
        JavaScriptPermissionUtilTest.assertTrue((boolean)JavaScriptPermissionUtil.isJavaScriptPermitted((FacesContext)this.getFacesContext()));
    }

    public void testPermitted3() throws Exception {
        MockExternalContext context = this.getExternalContext();
        context.setRequestPathInfo("/i/hoge");
        FacesConfigOptions.setJavascriptNotPermittedPath((String[])new String[]{"/au"});
        JavaScriptPermissionUtilTest.assertTrue((boolean)JavaScriptPermissionUtil.isJavaScriptPermitted((FacesContext)this.getFacesContext()));
    }

    public void testPermitted4() throws Exception {
        MockExternalContext context = this.getExternalContext();
        context.setRequestPathInfo("/index.html");
        FacesConfigOptions.setJavascriptNotPermittedPath((String[])new String[]{"/i"});
        JavaScriptPermissionUtilTest.assertTrue((boolean)JavaScriptPermissionUtil.isJavaScriptPermitted((FacesContext)this.getFacesContext()));
    }
}

