/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import org.seasar.framework.mock.servlet.MockHttpServletResponse;
import org.seasar.teeda.core.mock.MockBodyContent;
import org.seasar.teeda.core.mock.MockExternalContextImpl;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockFacesContextImpl;
import org.seasar.teeda.core.mock.MockJspWriter;
import org.seasar.teeda.core.mock.MockPageContext;
import org.seasar.teeda.core.mock.MockResponseWriter;
import org.seasar.teeda.core.taglib.core.ViewTag;
import org.seasar.teeda.core.unit.ExceptionAssert;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ViewTagTest
extends TeedaTestCase {
    protected void teatDown() throws Exception {
        this.setFacesContext((MockFacesContext)new MockFacesContextImpl(this.getExternalContext(), (Application)this.getApplication()));
    }

    public void testGetComponentType() throws Exception {
        ViewTag tag = new ViewTag();
        ViewTagTest.assertEquals((String)"javax.faces.ViewRoot", (String)tag.getComponentType());
    }

    public void testGetRenderType() throws Exception {
        ViewTag tag = new ViewTag();
        ViewTagTest.assertEquals(null, (String)tag.getRendererType());
    }

    public void testSetProperties_locale() throws Exception {
        MockPageContext pageContext = new MockPageContext();
        pageContext.setRequest((ServletRequest)this.getRequest());
        UIViewRoot viewRoot = this.createUIViewRoot();
        viewRoot.setLocale(Locale.CANADA);
        ViewTag tag = new ViewTag();
        tag.setPageContext((PageContext)pageContext);
        tag.setLocale(Locale.FRENCH.toString());
        tag.setProperties((UIComponent)viewRoot);
        ViewTagTest.assertEquals((Object)Locale.FRENCH, (Object)viewRoot.getLocale());
    }

    public void testSetProperties_nullLocale() throws Exception {
        MockPageContext pageContext = new MockPageContext();
        pageContext.setRequest((ServletRequest)this.getRequest());
        UIViewRoot viewRoot = this.createUIViewRoot();
        viewRoot.setLocale(Locale.CANADA);
        ViewTag tag = new ViewTag();
        tag.setPageContext((PageContext)pageContext);
        tag.setProperties((UIComponent)viewRoot);
        ViewTagTest.assertEquals((Object)Locale.CANADA, (Object)viewRoot.getLocale());
    }

    public void testDoStartTag() throws Exception {
        ViewTag tag = new ViewTag();
        MockPageContext pageContext = new MockPageContext();
        pageContext.setRequest((ServletRequest)this.getRequest());
        pageContext.setResponse((ServletResponse)this.getResponse());
        tag.setPageContext((PageContext)pageContext);
        tag.setParent(null);
        int rc = tag.doStartTag();
        ViewTagTest.assertEquals((int)2, (int)rc);
    }

    public void testDoStartTag_NullContext() throws Exception {
        ViewTag tag = new ViewTag();
        MockPageContext pageContext = new MockPageContext();
        pageContext.setRequest((ServletRequest)this.getRequest());
        pageContext.setResponse((ServletResponse)this.getResponse());
        tag.setPageContext((PageContext)pageContext);
        tag.setParent(null);
        this.setCurrentInstanceNull();
        try {
            tag.doStartTag();
            ViewTagTest.fail();
        }
        catch (Exception e) {
            ExceptionAssert.assertMessageExist(e);
        }
    }

    public void testDoStartTag_WriterException() throws Exception {
        ViewTag tag = new ViewTag();
        MockPageContext pageContext = new MockPageContext();
        pageContext.setRequest((ServletRequest)this.getRequest());
        pageContext.setResponse((ServletResponse)this.getResponse());
        tag.setPageContext((PageContext)pageContext);
        tag.setParent(null);
        MockResponseWriter writer = new MockResponseWriter(){

            public void startDocument() throws IOException {
                throw new IOException("TestException");
            }
        };
        this.getFacesContext().setResponseWriter((ResponseWriter)writer);
        try {
            tag.doStartTag();
            ViewTagTest.fail();
        }
        catch (JspException e) {
            ExceptionAssert.assertMessageExist(e);
        }
    }

    public void testDoStartTag_SetContentTypeNull() throws Exception {
        ViewTag tag = new ViewTag();
        MockPageContext pageContext = new MockPageContext();
        pageContext.setRequest((ServletRequest)this.getRequest());
        pageContext.setResponse((ServletResponse)this.getResponse());
        tag.setPageContext((PageContext)pageContext);
        tag.setParent(null);
        MockFacesContext context = this.getFacesContext();
        context.setExternalContext((ExternalContext)new MockExternalContextImpl(){
            private Map requestHeaderMap = new HashMap();

            public Map getRequestHeaderMap() {
                return this.requestHeaderMap;
            }
        });
        context.getExternalContext().getRequestHeaderMap().put("Accept", null);
        tag.doStartTag();
        String contentType = pageContext.getResponse().getContentType();
        ViewTagTest.assertEquals((String)"text/html; charset=ISO-8859-1", (String)contentType);
    }

    public void testDoStartTag_SetContentType() throws Exception {
        ViewTag tag = new ViewTag();
        MockPageContext pageContext = new MockPageContext();
        pageContext.setRequest((ServletRequest)this.getRequest());
        pageContext.setResponse((ServletResponse)this.getResponse());
        tag.setPageContext((PageContext)pageContext);
        tag.setParent(null);
        MockFacesContext context = this.getFacesContext();
        context.setExternalContext((ExternalContext)new MockExternalContextImpl(){
            private Map requestHeaderMap = new HashMap();

            public Map getRequestHeaderMap() {
                return this.requestHeaderMap;
            }
        });
        context.getExternalContext().getRequestHeaderMap().put("accept", "application/xhtml+xml");
        tag.doStartTag();
        String contentType = pageContext.getResponse().getContentType();
        ViewTagTest.assertTrue((contentType.indexOf("application/xhtml+xml") != -1 ? 1 : 0) != 0);
    }

    public void testDoAfterBody() throws Exception {
        ViewTag tag = new ViewTag();
        tag.setBodyContent((BodyContent)new MockBodyContent());
        int rc = tag.doAfterBody();
        ViewTagTest.assertEquals((int)6, (int)rc);
    }

    public void testDoAfterBody_NullContext() throws Exception {
        ViewTag tag = new ViewTag();
        tag.setBodyContent((BodyContent)new MockBodyContent());
        this.setCurrentInstanceNull();
        try {
            tag.doAfterBody();
            ViewTagTest.fail();
        }
        catch (NullPointerException e) {
            ExceptionAssert.assertMessageExist(e);
        }
    }

    public void testDoAfterBody_NullBodyContent() throws Exception {
        ViewTag tag = new ViewTag(){

            public BodyContent getBodyContent() {
                return null;
            }
        };
        tag.setBodyContent((BodyContent)new MockBodyContent());
        try {
            tag.doAfterBody();
            ViewTagTest.fail();
        }
        catch (JspException e) {
            ExceptionAssert.assertMessageExist(e);
        }
    }

    public void testDoAfterBody_WriteException() throws Exception {
        ViewTag tag = new ViewTag();
        final IOException toThrowException = new IOException("TestException");
        MockJspWriter writer = new MockJspWriter(){

            public void write(String s) throws IOException {
                throw toThrowException;
            }
        };
        tag.setBodyContent((BodyContent)new MockBodyContent(writer));
        try {
            tag.doAfterBody();
            ViewTagTest.fail();
        }
        catch (JspException e) {
            Throwable cause = e.getRootCause();
            ViewTagTest.assertSame((Object)toThrowException, (Object)cause);
        }
    }

    public void testDoEndTag() throws Exception {
        ViewTag tag = new ViewTag();
        MockPageContext pageContext = new MockPageContext();
        pageContext.setRequest((ServletRequest)this.getRequest());
        pageContext.setResponse((ServletResponse)this.getResponse());
        tag.setPageContext((PageContext)pageContext);
        tag.setParent(null);
        tag.setBodyContent((BodyContent)new MockBodyContent());
        tag.doStartTag();
        tag.doAfterBody();
        int rc = tag.doEndTag();
        ViewTagTest.assertEquals((int)rc, (int)6);
    }

    public void testDoEndTag_SetCharacterEncoding() throws Exception {
        ViewTag tag = new ViewTag();
        MockPageContext pageContext = new MockPageContext();
        pageContext.setRequest((ServletRequest)this.getRequest());
        MockHttpServletResponse response = this.getResponse();
        response.setCharacterEncoding("windows-31j");
        pageContext.setResponse((ServletResponse)response);
        pageContext.setSession(this.getRequest().getSession());
        tag.setPageContext((PageContext)pageContext);
        tag.setParent(null);
        tag.setBodyContent((BodyContent)new MockBodyContent());
        tag.doStartTag();
        tag.doAfterBody();
        tag.doEndTag();
        ViewTagTest.assertEquals((Object)"windows-31j", (Object)pageContext.getSession().getAttribute("javax.faces.request.charset"));
    }

    public void testDoEndTag_WriteException() throws Exception {
        ViewTag tag = new ViewTag();
        final IOException toThrowException = new IOException("TestException");
        MockResponseWriter writer = new MockResponseWriter(){

            public void endDocument() throws IOException {
                throw toThrowException;
            }
        };
        this.getFacesContext().setResponseWriter((ResponseWriter)writer);
        MockPageContext pageContext = new MockPageContext();
        pageContext.setRequest((ServletRequest)this.getRequest());
        pageContext.setResponse((ServletResponse)this.getResponse());
        tag.setPageContext((PageContext)pageContext);
        tag.setParent(null);
        tag.setBodyContent((BodyContent)new MockBodyContent());
        tag.doStartTag();
        tag.doAfterBody();
        this.getFacesContext().setResponseWriter((ResponseWriter)writer);
        try {
            tag.doEndTag();
            ViewTagTest.fail();
        }
        catch (JspException e) {
            Throwable cause = e.getRootCause();
            ViewTagTest.assertSame((Object)toThrowException, (Object)cause);
        }
    }

    private UIViewRoot createUIViewRoot() {
        return this.createUIComponent();
    }

    protected UIViewRoot createUIComponent() {
        return new UIViewRoot();
    }

    private void setCurrentInstanceNull() {
        OrgFacesContextImpl contextImpl = new OrgFacesContextImpl();
        contextImpl.setCurrentInstanceNull();
    }

    private class OrgFacesContextImpl
    extends MockFacesContextImpl {
        private OrgFacesContextImpl() {
        }

        public void setCurrentInstanceNull() {
            OrgFacesContextImpl.setCurrentInstance(null);
        }
    }
}

