/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlMessage;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockUIComponentBase;
import org.seasar.teeda.core.render.html.HtmlMessageRenderer;
import org.seasar.teeda.core.unit.ExceptionAssert;

public class HtmlMessageRendererTest
extends RendererTest {
    private HtmlMessageRenderer renderer;
    private MockHtmlMessage htmlMessage;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlMessageRenderer();
        this.htmlMessage = new MockHtmlMessage();
        this.htmlMessage.setRenderer((Renderer)this.renderer);
    }

    public void testEncode_NullForAttribute() throws Exception {
        this.arrangeForComponent("fooFor");
        this.htmlMessage.setFor(null);
        try {
            this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        }
        catch (FacesException fe) {
            ExceptionAssert.assertMessageExist(fe);
        }
    }

    public void testEncode_NoForComponent() throws Exception {
        this.arrangeForComponent("fooFor");
        this.htmlMessage.setFor("barFor");
        try {
            this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        }
        catch (FacesException fe) {
            ExceptionAssert.assertMessageExist(fe);
        }
    }

    public void testEncode_NoMessage() throws Exception {
        this.arrangeForComponent("fooFor");
        this.htmlMessage.setFor("fooFor");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_NoMessageValue() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("fooFor");
        this.htmlMessage.setFor("fooFor");
        FacesMessage facesMessage = new FacesMessage();
        context.addMessage("fooFor", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_Detail() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("fooFor");
        this.htmlMessage.setFor("fooFor");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("detail");
        context.addMessage("fooFor", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"detail", (String)this.getResponseText());
    }

    public void testEncode_Detail_NoEscape() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("fooFor");
        this.htmlMessage.setFor("fooFor");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("<detail>");
        context.addMessage("fooFor", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"<detail>", (String)this.getResponseText());
    }

    public void testEncode_FirstMessageOnly() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("fooFor");
        this.htmlMessage.setFor("fooFor");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("first");
        context.addMessage("fooFor", facesMessage);
        facesMessage = new FacesMessage();
        facesMessage.setDetail("second");
        context.addMessage("fooFor", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"first", (String)this.getResponseText());
    }

    public void testEncode_Summary() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("fooFor");
        this.htmlMessage.setFor("fooFor");
        this.htmlMessage.setShowSummary(true);
        this.htmlMessage.setShowDetail(false);
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("summary");
        context.addMessage("fooFor", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"summary", (String)this.getResponseText());
    }

    public void testEncode_Summary_NoEscape() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("fooFor");
        this.htmlMessage.setFor("fooFor");
        this.htmlMessage.setShowSummary(true);
        this.htmlMessage.setShowDetail(false);
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("<summary>");
        context.addMessage("fooFor", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"<summary>", (String)this.getResponseText());
    }

    public void testEncode_SummaryAndDetail() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("fooFor");
        this.htmlMessage.setFor("fooFor");
        this.htmlMessage.setShowSummary(true);
        this.htmlMessage.setShowDetail(true);
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("ss");
        facesMessage.setDetail("dd");
        context.addMessage("fooFor", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"ss dd", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlMessage.setRendered(false);
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("fooFor");
        this.htmlMessage.setFor("fooFor");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("detail");
        context.addMessage("fooFor", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_Id() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("foo");
        this.htmlMessage.setId("ab");
        this.htmlMessage.setFor("foo");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("detail");
        facesMessage.setSeverity(FacesMessage.SEVERITY_INFO);
        context.addMessage("foo", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"<span id=\"ab\">detail</span>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute1() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("foo");
        this.htmlMessage.setFor("foo");
        this.htmlMessage.getAttributes().put("aa", "bb");
        this.htmlMessage.getAttributes().put("a.a", "bbb");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("detail");
        facesMessage.setSeverity(FacesMessage.SEVERITY_INFO);
        context.addMessage("foo", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"<span aa=\"bb\">detail</span>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute2() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("foo");
        this.htmlMessage.setFor("foo");
        this.htmlMessage.getAttributes().put("a.a", "bb");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("detail");
        facesMessage.setSeverity(FacesMessage.SEVERITY_INFO);
        context.addMessage("foo", facesMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"detail", (String)this.getResponseText());
    }

    public void testEncode_InfoStyle() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("foo");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("detail");
        facesMessage.setSeverity(FacesMessage.SEVERITY_INFO);
        context.addMessage("foo", facesMessage);
        this.htmlMessage.setInfoStyle("aaa");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"<span style=\"aaa\">detail</span>", (String)this.getResponseText());
    }

    public void testEncode_InfoClass() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("foo");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("detail");
        facesMessage.setSeverity(FacesMessage.SEVERITY_INFO);
        context.addMessage("foo", facesMessage);
        this.htmlMessage.setInfoClass("bb");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"<span class=\"bb\">detail</span>", (String)this.getResponseText());
    }

    public void testEncode_StyleClassAndWarnStyle() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("foo");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("detail");
        facesMessage.setSeverity(FacesMessage.SEVERITY_WARN);
        context.addMessage("foo", facesMessage);
        this.htmlMessage.setStyle("ss");
        this.htmlMessage.setWarnClass("tt");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"<span style=\"ss\" class=\"tt\">detail</span>", (String)this.getResponseText());
    }

    public void testEncode_ErrorStyleAndStyleClass() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("foo");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("detail");
        facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
        context.addMessage("foo", facesMessage);
        this.htmlMessage.setErrorStyle("ee");
        this.htmlMessage.setStyleClass("ss");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"<span style=\"ee\" class=\"ss\">detail</span>", (String)this.getResponseText());
    }

    public void testEncode_InfoStyleAndInfoClass() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("foo");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("detail");
        facesMessage.setSeverity(FacesMessage.SEVERITY_INFO);
        context.addMessage("foo", facesMessage);
        this.arrangeStyles(this.htmlMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"<span style=\"is\" class=\"ic\">detail</span>", (String)this.getResponseText());
    }

    public void testEncode_WarnStyleAndWarnClass() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("foo");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("detail");
        facesMessage.setSeverity(FacesMessage.SEVERITY_WARN);
        context.addMessage("foo", facesMessage);
        this.arrangeStyles(this.htmlMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"<span style=\"ws\" class=\"wc\">detail</span>", (String)this.getResponseText());
    }

    public void testEncode_ErrorStyleAndErrorClass() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("foo");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("d");
        facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
        context.addMessage("foo", facesMessage);
        this.arrangeStyles(this.htmlMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"<span style=\"es\" class=\"ec\">d</span>", (String)this.getResponseText());
    }

    private void arrangeForComponent(String id) {
        MockUIComponentBase forComponent = new MockUIComponentBase();
        forComponent.setId(id);
        this.htmlMessage.getChildren().add(forComponent);
        this.htmlMessage.setFor(id);
    }

    public void testEncode_FatalStyleAndFatalClass() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("foo");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("d");
        facesMessage.setSeverity(FacesMessage.SEVERITY_FATAL);
        context.addMessage("foo", facesMessage);
        this.arrangeStyles(this.htmlMessage);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"<span style=\"fs\" class=\"fc\">d</span>", (String)this.getResponseText());
    }

    public void testEncode_StyleAndStyleClass() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("foo");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("d");
        context.addMessage("foo", facesMessage);
        this.htmlMessage.setStyle("s1");
        this.htmlMessage.setStyleClass("s2");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"<span style=\"s1\" class=\"s2\">d</span>", (String)this.getResponseText());
    }

    private void arrangeStyles(HtmlMessage htmlMessage) {
        htmlMessage.setInfoClass("ic");
        htmlMessage.setInfoStyle("is");
        htmlMessage.setWarnClass("wc");
        htmlMessage.setWarnStyle("ws");
        htmlMessage.setErrorClass("ec");
        htmlMessage.setErrorStyle("es");
        htmlMessage.setFatalClass("fc");
        htmlMessage.setFatalStyle("fs");
        htmlMessage.setStyle("s");
        htmlMessage.setStyleClass("sc");
    }

    public void testEncode_Title() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("foo");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setDetail("d");
        context.addMessage("foo", facesMessage);
        this.htmlMessage.setTitle("t");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"<span title=\"t\">d</span>", (String)this.getResponseText());
    }

    public void testEncode_Tooltip() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("foo");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        facesMessage.setDetail("d");
        context.addMessage("foo", facesMessage);
        this.htmlMessage.setTooltip(true);
        this.htmlMessage.setShowSummary(true);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"<span title=\"s\">d</span>", (String)this.getResponseText());
    }

    public void testEncode_TitleAndTooltip() throws Exception {
        MockFacesContext context = this.getFacesContext();
        this.arrangeForComponent("bar");
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSummary("s");
        facesMessage.setDetail("d");
        context.addMessage("bar", facesMessage);
        this.htmlMessage.setTitle("t");
        this.htmlMessage.setTooltip(true);
        this.htmlMessage.setShowSummary(true);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlMessage);
        HtmlMessageRendererTest.assertEquals((String)"prioritize [tooltip] over [title]", (String)"<span title=\"s\">d</span>", (String)this.getResponseText());
    }

    public void testGetRendersChildren() throws Exception {
        HtmlMessageRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlMessageRenderer createHtmlMessageRenderer() {
        return (HtmlMessageRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlMessageRenderer renderer = new HtmlMessageRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }

    private static class MockHtmlMessage
    extends HtmlMessage {
        private Renderer renderer_;
        private String clientId_;

        private MockHtmlMessage() {
        }

        public void setRenderer(Renderer renderer) {
            this.renderer_ = renderer;
        }

        protected Renderer getRenderer(FacesContext context) {
            if (this.renderer_ != null) {
                return this.renderer_;
            }
            return super.getRenderer(context);
        }

        public String getClientId(FacesContext context) {
            if (this.clientId_ != null) {
                return this.clientId_;
            }
            return super.getClientId(context);
        }

        public void setClientId(String clientId) {
            this.clientId_ = clientId;
        }
    }
}

