/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlInputSecret;
import org.seasar.teeda.core.mock.MockUIComponentBaseWithNamingContainer;
import org.seasar.teeda.core.render.html.HtmlInputSecretRenderer;

public class HtmlInputSecretRendererTest
extends RendererTest {
    private HtmlInputSecretRenderer renderer;
    private MockHtmlInputSecret htmlInputSecret;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlInputSecretRenderer();
        this.htmlInputSecret = new MockHtmlInputSecret();
        this.htmlInputSecret.setRenderer((Renderer)this.renderer);
    }

    public void testEncode_NoValue() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputSecret);
        HtmlInputSecretRendererTest.assertEquals((String)"<input type=\"password\" name=\"_id0\" value=\"\" />", (String)this.getResponseText());
    }

    public void testEncodeEnd_RenderFalse() throws Exception {
        this.htmlInputSecret.setRendered(false);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlInputSecret);
        this.renderer.encodeEnd((FacesContext)context, (UIComponent)this.htmlInputSecret);
        HtmlInputSecretRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_WithValue() throws Exception {
        this.htmlInputSecret.setValue("abc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputSecret);
        HtmlInputSecretRendererTest.assertEquals((String)"<input type=\"password\" name=\"_id0\" value=\"\" />", (String)this.getResponseText());
    }

    public void testEncode_WithValueRedisplayTrue() throws Exception {
        this.htmlInputSecret.setValue("abc");
        this.htmlInputSecret.setRedisplay(true);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputSecret);
        HtmlInputSecretRendererTest.assertEquals((String)"<input type=\"password\" name=\"_id0\" value=\"abc\" />", (String)this.getResponseText());
    }

    public void testEncode_WithValueRedisplayTrue2() throws Exception {
        this.htmlInputSecret.setValue("&hearts;");
        this.htmlInputSecret.setRedisplay(true);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputSecret);
        HtmlInputSecretRendererTest.assertEquals((String)"<input type=\"password\" name=\"_id0\" value=\"&amp;hearts;\" />", (String)this.getResponseText());
    }

    public void testEncode_WithId() throws Exception {
        this.htmlInputSecret.setId("a");
        MockUIComponentBaseWithNamingContainer parent = new MockUIComponentBaseWithNamingContainer();
        parent.setId("b");
        parent.getChildren().add(this.htmlInputSecret);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputSecret);
        HtmlInputSecretRendererTest.assertEquals((String)"<input type=\"password\" id=\"a\" name=\"b:a\" value=\"\" />", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute() throws Exception {
        this.htmlInputSecret.setId("a");
        this.htmlInputSecret.getAttributes().put("foo", "bar");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputSecret);
        HtmlInputSecretRendererTest.assertEquals((String)"<input type=\"password\" id=\"a\" name=\"a\" value=\"\" foo=\"bar\" />", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlInputSecret.setAccesskey("a");
        this.htmlInputSecret.setAlt("b");
        this.htmlInputSecret.setDir("c");
        this.htmlInputSecret.setDisabled(true);
        this.htmlInputSecret.setLang("e");
        this.htmlInputSecret.setMaxlength(5);
        this.htmlInputSecret.setOnblur("g");
        this.htmlInputSecret.setOnchange("h");
        this.htmlInputSecret.setOnclick("i");
        this.htmlInputSecret.setOndblclick("j");
        this.htmlInputSecret.setOnfocus("k");
        this.htmlInputSecret.setOnkeydown("l");
        this.htmlInputSecret.setOnkeypress("m");
        this.htmlInputSecret.setOnkeyup("n");
        this.htmlInputSecret.setOnmousedown("o");
        this.htmlInputSecret.setOnmousemove("p");
        this.htmlInputSecret.setOnmouseout("q");
        this.htmlInputSecret.setOnmouseover("r");
        this.htmlInputSecret.setOnmouseup("s");
        this.htmlInputSecret.setOnselect("t");
        this.htmlInputSecret.setReadonly(true);
        this.htmlInputSecret.setSize(2);
        this.htmlInputSecret.setStyle("w");
        this.htmlInputSecret.setStyleClass("u");
        this.htmlInputSecret.setTabindex("x");
        this.htmlInputSecret.setTitle("y");
        this.htmlInputSecret.getAttributes().put("type", "password");
        this.htmlInputSecret.getAttributes().put("name", "hoge");
        this.htmlInputSecret.setId("Aa");
        this.htmlInputSecret.setValue("Ba");
        this.htmlInputSecret.setRedisplay(false);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputSecret);
        Diff diff = new Diff("<input type=\"password\" id=\"Aa\" name=\"Aa\" value=\"\" accesskey=\"a\" alt=\"b\" dir=\"c\" disabled=\"disabled\" lang=\"e\" maxlength=\"5\" onblur=\"g\" onchange=\"h\" onclick=\"i\" ondblclick=\"j\" onfocus=\"k\" onkeydown=\"l\" onkeypress=\"m\" onkeyup=\"n\" onmousedown=\"o\" onmousemove=\"p\" onmouseout=\"q\" onmouseover=\"r\" onmouseup=\"s\" onselect=\"t\" readonly=\"readonly\" size=\"2\" style=\"w\" class=\"u\" tabindex=\"x\" title=\"y\"/>", this.getResponseText());
        HtmlInputSecretRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testDecode_None() throws Exception {
        this.htmlInputSecret.setClientId("key");
        MockFacesContext context = this.getFacesContext();
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlInputSecret);
        HtmlInputSecretRendererTest.assertEquals(null, (Object)this.htmlInputSecret.getSubmittedValue());
    }

    public void testDecode_Success() throws Exception {
        this.htmlInputSecret.setClientId("key");
        MockFacesContext context = this.getFacesContext();
        context.getExternalContext().getRequestParameterMap().put("key", "12345");
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlInputSecret);
        HtmlInputSecretRendererTest.assertEquals((Object)"12345", (Object)this.htmlInputSecret.getSubmittedValue());
    }

    public void testGetRendersChildren() throws Exception {
        HtmlInputSecretRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlInputSecretRenderer createHtmlInputSecretRenderer() {
        return (HtmlInputSecretRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlInputSecretRenderer renderer = new HtmlInputSecretRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }
}

