/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.internal.IgnoreAttribute;
import javax.faces.render.RendererTest;
import org.seasar.teeda.core.render.AbstractRenderer;

public class AbstractRendererTest
extends RendererTest {
    private AbstractRenderer renderer = new AbstractRenderer(){};

    public void testSplitByComma() throws Exception {
        String[] result = this.renderer.splitByComma("a, b  ,c , d");
        AbstractRendererTest.assertEquals((int)4, (int)result.length);
        AbstractRendererTest.assertEquals((String)"a", (String)result[0]);
        AbstractRendererTest.assertEquals((String)"b", (String)result[1]);
        AbstractRendererTest.assertEquals((String)"c", (String)result[2]);
        AbstractRendererTest.assertEquals((String)"d", (String)result[3]);
    }

    public void testGetAllAttributesAndProperties_setIgnore() throws Exception {
        MockNoComponent component = new MockNoComponent();
        component.setHoge("aaa");
        IgnoreAttribute ignore = new IgnoreAttribute();
        ignore.addAttributeName("hoge");
        ignore.addAttributeName("id");
        Map map = this.renderer.getAllAttributesAndProperties((UIComponent)component, ignore);
        AbstractRendererTest.assertTrue((map.size() == 0 ? 1 : 0) != 0);
    }

    public static class MockNoComponent
    extends UIComponentBase {
        private String hoge;

        public String getHoge() {
            return this.hoge;
        }

        public void setHoge(String hoge) {
            this.hoge = hoge;
        }

        public String getFamily() {
            return "none";
        }
    }
}

