/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.assembler.impl;

import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import org.seasar.teeda.core.config.faces.assembler.impl.NavigationHandlerAssembler;
import org.seasar.teeda.core.mock.MockNavigationHandler;
import org.seasar.teeda.core.mock.MockSingleConstructorNavigationHandler;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class NavigationHandlerAssemblerTest
extends TeedaTestCase {
    public NavigationHandlerAssemblerTest(String name) {
        super(name);
    }

    public void testSimpleAssembleNavigationHandler() throws Exception {
        String navHandlerName = "org.seasar.teeda.core.mock.MockNavigationHandler";
        NavigationHandlerAssembler assembler = new NavigationHandlerAssembler(navHandlerName, (Application)this.getApplication());
        assembler.assemble();
        NavigationHandler handler = this.getApplication().getNavigationHandler();
        NavigationHandlerAssemblerTest.assertNotNull((Object)handler);
        NavigationHandlerAssemblerTest.assertTrue((boolean)(handler instanceof MockNavigationHandler));
    }

    public void testMarshalAssembleNavigationHandler() throws Exception {
        this.getApplication().setNavigationHandler((NavigationHandler)new MockNavigationHandler());
        String navHandlerName = "org.seasar.teeda.core.mock.MockSingleConstructorNavigationHandler";
        NavigationHandlerAssembler assembler = new NavigationHandlerAssembler(navHandlerName, (Application)this.getApplication());
        assembler.assemble();
        NavigationHandler handler = this.getApplication().getNavigationHandler();
        NavigationHandlerAssemblerTest.assertNotNull((Object)handler);
        NavigationHandlerAssemblerTest.assertTrue((boolean)(handler instanceof MockSingleConstructorNavigationHandler));
        MockSingleConstructorNavigationHandler h = (MockSingleConstructorNavigationHandler)handler;
        NavigationHandlerAssemblerTest.assertTrue((boolean)(h.getOriginal() instanceof MockNavigationHandler));
    }
}

