/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.assembler.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.internal.FactoryFinderUtil;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import org.seasar.teeda.core.JsfConstants;
import org.seasar.teeda.core.config.faces.assembler.impl.DefaultRenderKitAssembler;
import org.seasar.teeda.core.config.faces.element.RenderKitElement;
import org.seasar.teeda.core.config.faces.element.RendererElement;
import org.seasar.teeda.core.config.faces.element.impl.RenderKitElementImpl;
import org.seasar.teeda.core.config.faces.element.impl.RendererElementImpl;
import org.seasar.teeda.core.mock.MockRenderKit;
import org.seasar.teeda.core.mock.MockRenderKitImpl;
import org.seasar.teeda.core.mock.MockRenderer;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class DefaultRenderKitAssemblerTest
extends TeedaTestCase {
    public void testAssemble() throws Exception {
        String id = "id";
        RenderKitElementImpl renderKitElement = new RenderKitElementImpl();
        renderKitElement.setRenderKitId(id);
        renderKitElement.setRenderKitClass("org.seasar.teeda.core.mock.MockRenderKitImpl");
        RendererElementImpl rendererElement = new RendererElementImpl();
        rendererElement.setComponentFamily("family");
        rendererElement.setRendererClass("org.seasar.teeda.core.mock.MockRenderer");
        rendererElement.setRendererType("type");
        renderKitElement.addRendererElement((RendererElement)rendererElement);
        HashMap<String, RenderKitElementImpl> map = new HashMap<String, RenderKitElementImpl>();
        map.put(id, renderKitElement);
        DefaultRenderKitAssembler assembler = this.createAssembler(map);
        assembler.assemble();
        RenderKitFactory factory = FactoryFinderUtil.getRenderKitFactory();
        RenderKit kit = factory.getRenderKit((FacesContext)this.getFacesContext(), id);
        DefaultRenderKitAssemblerTest.assertNotNull((Object)kit);
        DefaultRenderKitAssemblerTest.assertTrue((boolean)(kit instanceof MockRenderKit));
        Renderer renderer = kit.getRenderer("family", "type");
        DefaultRenderKitAssemblerTest.assertNotNull((Object)renderer);
        DefaultRenderKitAssemblerTest.assertTrue((boolean)(renderer instanceof MockRenderer));
    }

    public void testGetDefaultRenderKitId() throws Exception {
        RenderKitElementImpl renderKitElement = new RenderKitElementImpl();
        RendererElementImpl rendererElement = new RendererElementImpl();
        rendererElement.setComponentFamily("family");
        rendererElement.setRendererClass("org.seasar.teeda.core.mock.MockRenderer");
        rendererElement.setRendererType("type");
        renderKitElement.addRendererElement((RendererElement)rendererElement);
        HashMap<Object, RenderKitElementImpl> map = new HashMap<Object, RenderKitElementImpl>();
        map.put(null, renderKitElement);
        DefaultRenderKitAssembler assembler = this.createAssembler(map);
        assembler.assemble();
        List renderList = assembler.getRenderList();
        Iterator it = renderList.iterator();
        DefaultRenderKitAssemblerTest.assertEquals((boolean)true, (boolean)it.hasNext());
        DefaultRenderKitAssembler.RenderKitBean bean = (DefaultRenderKitAssembler.RenderKitBean)it.next();
        DefaultRenderKitAssemblerTest.assertEquals((String)"HTML_BASIC", (String)bean.getRenderKitId());
        DefaultRenderKitAssemblerTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testGetDefaultRenderKitClassName() throws Exception {
        DefaultRenderKitAssembler assembler = this.createAssembler();
        RenderKitElementImpl element = new RenderKitElementImpl();
        String className = assembler.getRenderKitClassName((RenderKitElement)element);
        DefaultRenderKitAssemblerTest.assertEquals((String)JsfConstants.DEFAULT_RENDERKIT_CLASS, (String)className);
    }

    public void testCreateRendererSucceed() throws Exception {
        DefaultRenderKitAssembler assembler = this.createAssembler();
        Renderer r = assembler.createRenderer("org.seasar.teeda.core.mock.MockRenderer");
        DefaultRenderKitAssemblerTest.assertTrue((boolean)(r instanceof MockRenderer));
    }

    public void testCreateRendererReturnNull() throws Exception {
        DefaultRenderKitAssembler assembler = this.createAssembler();
        Renderer r = assembler.createRenderer("nosuchpackage.NoSuchRenderer");
        DefaultRenderKitAssemblerTest.assertNull((Object)r);
    }

    public void testCreateRenderKitSucceed() throws Exception {
        DefaultRenderKitAssembler assembler = this.createAssembler();
        RenderKit renderKit = assembler.createRenderKit("org.seasar.teeda.core.mock.MockRenderKitImpl");
        DefaultRenderKitAssemblerTest.assertTrue((boolean)(renderKit instanceof MockRenderKit));
    }

    public void testCreateRenderKitReturnsFromContainerIfRegistered() throws Exception {
        DefaultRenderKitAssembler assembler = this.createAssembler();
        MockRenderKitImpl registeredRenderKit = new MockRenderKitImpl();
        this.getContainer().register((Object)registeredRenderKit);
        RenderKit renderKit = assembler.createRenderKit(MockRenderKitImpl.class.getName());
        DefaultRenderKitAssemblerTest.assertSame((Object)registeredRenderKit, (Object)renderKit);
    }

    private DefaultRenderKitAssembler createAssembler() {
        HashMap map = new HashMap();
        return this.createAssembler(map);
    }

    private DefaultRenderKitAssembler createAssembler(Map map) {
        DefaultRenderKitAssembler assembler = new DefaultRenderKitAssembler(map);
        return assembler;
    }
}

