/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.assembler.impl;

import java.util.HashMap;
import org.seasar.teeda.core.config.faces.assembler.impl.DefaultManagedBeanAssembler;
import org.seasar.teeda.core.config.faces.element.ManagedPropertyElement;
import org.seasar.teeda.core.config.faces.element.impl.ManagedBeanElementImpl;
import org.seasar.teeda.core.config.faces.element.impl.ManagedPropertyElementImpl;
import org.seasar.teeda.core.managedbean.ManagedBeanFactory;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class DefaultManagedBeanAssemblerTest
extends TeedaTestCase {
    public void testSimplyAssemble() throws Exception {
        ManagedBeanElementImpl mb = new ManagedBeanElementImpl();
        mb.setManagedBeanName("aaa");
        mb.setManagedBeanClass(((Object)((Object)this)).getClass().getName() + "$" + "A");
        mb.setManagedBeanScope("session");
        HashMap<String, ManagedBeanElementImpl> map = new HashMap<String, ManagedBeanElementImpl>();
        map.put(mb.getManagedBeanName(), mb);
        DefaultManagedBeanAssembler assembler = new DefaultManagedBeanAssembler(map);
        assembler.assemble();
        ManagedBeanFactory factory = this.getManagedBeanFactory();
        A a = (A)factory.getManagedBean("aaa");
        DefaultManagedBeanAssemblerTest.assertEquals((String)"default", (String)a.getName());
    }

    public void fixme_testComplexAssemble() throws Exception {
        this.getServletContext().setInitParameter("hoge", "foo");
        ManagedBeanElementImpl mb = new ManagedBeanElementImpl();
        mb.setManagedBeanName("aaa");
        mb.setManagedBeanClass(((Object)((Object)this)).getClass().getName() + "$" + "A");
        mb.setManagedBeanScope("session");
        ManagedPropertyElementImpl p = new ManagedPropertyElementImpl();
        p.setPropertyName("name");
        p.setValue("#{initParam.hoge}");
        mb.addManagedPropertyElement((ManagedPropertyElement)p);
        HashMap<String, ManagedBeanElementImpl> map = new HashMap<String, ManagedBeanElementImpl>();
        map.put(mb.getManagedBeanName(), mb);
        DefaultManagedBeanAssembler assembler = new DefaultManagedBeanAssembler(map);
        assembler.assemble();
        ManagedBeanFactory factory = this.getManagedBeanFactory();
        A a = (A)factory.getManagedBean("aaa");
        DefaultManagedBeanAssemblerTest.assertEquals((String)"foo", (String)a.getName());
    }

    public static class A {
        private String name_ = "default";

        public String getName() {
            return this.name_;
        }

        public void setName(String name) {
            this.name_ = name;
        }
    }
}

