/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.util.ArrayList;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.faces.model.ListDataModel;
import junit.framework.TestCase;
import org.seasar.teeda.core.mock.MockDataModelListener;

public class ListDataModelTest
extends TestCase {
    public void testIsRowAvailable() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        ListDataModel model = new ListDataModel(list);
        model.setRowIndex(0);
        ListDataModelTest.assertTrue((boolean)model.isRowAvailable());
        model.setRowIndex(list.size() - 1);
        ListDataModelTest.assertTrue((boolean)model.isRowAvailable());
        model.setRowIndex(-1);
        ListDataModelTest.assertFalse((boolean)model.isRowAvailable());
    }

    public void testGetRowCount() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("2");
        ListDataModel model = new ListDataModel(list);
        ListDataModelTest.assertEquals((int)list.size(), (int)model.getRowCount());
        model = new ListDataModel();
        ListDataModelTest.assertEquals((int)-1, (int)model.getRowCount());
    }

    public void testGetRowData() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        ListDataModel model = new ListDataModel(list);
        model.setRowIndex(1);
        ListDataModelTest.assertEquals(list.get(1), (Object)model.getRowData());
        model = new ListDataModel();
        ListDataModelTest.assertEquals(null, (Object)model.getRowData());
        model = new ListDataModel(list);
        model.setRowIndex(3);
        try {
            model.getRowData();
            ListDataModelTest.fail();
        }
        catch (IllegalArgumentException e) {
            ListDataModelTest.assertTrue((boolean)true);
        }
    }

    public void testGetRowIndex() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        ListDataModel model = new ListDataModel(list);
        model.setRowIndex(1);
        ListDataModelTest.assertEquals((int)1, (int)model.getRowIndex());
        model = new ListDataModel();
        ListDataModelTest.assertEquals((int)-1, (int)model.getRowIndex());
    }

    public void testSetRowIndex() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("2");
        ListDataModel model = new ListDataModel(list);
        MockDataModelListener listener = new MockDataModelListener();
        model.addDataModelListener((DataModelListener)listener);
        model.setRowIndex(1);
        DataModelEvent event = listener.getDataModelEvent();
        ListDataModelTest.assertEquals((Object)"2", (Object)event.getRowData());
        ListDataModelTest.assertEquals((int)1, (int)event.getRowIndex());
        try {
            model.setRowIndex(-2);
            ListDataModelTest.fail();
        }
        catch (IllegalArgumentException e) {
            ListDataModelTest.assertTrue((boolean)true);
        }
        ListDataModel model2 = new ListDataModel();
        MockDataModelListener listener2 = new MockDataModelListener();
        model2.addDataModelListener((DataModelListener)listener2);
        model2.setRowIndex(1);
        ListDataModelTest.assertNull((Object)listener2.getDataModelEvent());
        ArrayList<String> list3 = new ArrayList<String>();
        list3.add("d");
        list3.add("e");
        ListDataModel model3 = new ListDataModel(list3);
        MockDataModelListener listener3 = new MockDataModelListener();
        model3.addDataModelListener((DataModelListener)listener3);
        model3.setRowIndex(3);
        DataModelEvent event3 = listener3.getDataModelEvent();
        ListDataModelTest.assertNull((Object)event3.getRowData());
        ListDataModelTest.assertEquals((int)3, (int)event3.getRowIndex());
    }

    public void testGetWrappedData() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        ListDataModel model = new ListDataModel();
        model.setWrappedData(list);
        ListDataModelTest.assertEquals(list, (Object)model.getWrappedData());
    }

    public void testSetWrappedData() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("2");
        list.add("3");
        ListDataModel model = new ListDataModel();
        MockDataModelListener listener = new MockDataModelListener();
        model.addDataModelListener((DataModelListener)listener);
        model.setWrappedData(list);
        model.setRowIndex(1);
        ListDataModelTest.assertEquals((int)1, (int)model.getRowIndex());
        ListDataModelTest.assertNotNull((Object)model.getWrappedData());
        DataModelEvent event = listener.getDataModelEvent();
        ListDataModelTest.assertNotNull((Object)event);
        ListDataModelTest.assertEquals((Object)"2", (Object)event.getRowData());
        ListDataModelTest.assertEquals((int)1, (int)event.getRowIndex());
    }
}

