/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesConfigOptions;
import javax.faces.internal.LabelUtil;
import javax.faces.internal.web.foo.FooPage;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.convention.impl.NamingConventionImpl;
import org.seasar.framework.util.ClassUtil;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockFacesContextImpl;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class LabelUtilTest
extends TeedaTestCase {
    public void testGetLabelValue() throws Exception {
        NamingConventionImpl nc = (NamingConventionImpl)this.getContainer().getComponent((Object)NamingConvention.class);
        nc.addRootPackageName(ClassUtil.getPackageName(((Object)((Object)this)).getClass()));
        this.register(FooPage.class, "foo_fooPage");
        FacesConfigOptions.setDefaultSuffix((String)".html");
        this.getFacesContext().getViewRoot().setViewId(nc.getViewRootPath() + "/foo/foo.html");
        LabelUtilTest.assertEquals((String)"AAA", (String)LabelUtil.getLabelValue((String)"aaa"));
        LabelUtilTest.assertEquals((String)"AAA", (String)LabelUtil.getLabelValue((String)"aaa-input"));
    }

    public void testGetLabelValue_contextIsNull() throws Exception {
        MockFacesContext orgFacesContext = this.getFacesContext();
        NamingConventionImpl nc = (NamingConventionImpl)this.getContainer().getComponent((Object)NamingConvention.class);
        nc.addRootPackageName(ClassUtil.getPackageName(((Object)((Object)this)).getClass()));
        this.register(FooPage.class, "foo_fooPage");
        FacesConfigOptions.setDefaultSuffix((String)".html");
        orgFacesContext.getViewRoot().setViewId(nc.getViewRootPath() + "/foo/foo.html");
        MockFacesContext.setFacesContext(null);
        LabelUtilTest.assertNull((Object)LabelUtil.getLabelValue((String)"aaa"));
        this.setFacesContext(orgFacesContext);
        MockFacesContext.setFacesContext((FacesContext)orgFacesContext);
    }

    public void testGetLabelValue_viewRootIsNull() throws Exception {
        MockFacesContext orgFacesContext = this.getFacesContext();
        NamingConventionImpl nc = (NamingConventionImpl)this.getContainer().getComponent((Object)NamingConvention.class);
        nc.addRootPackageName(ClassUtil.getPackageName(((Object)((Object)this)).getClass()));
        this.register(FooPage.class, "foo_fooPage");
        FacesConfigOptions.setDefaultSuffix((String)".html");
        orgFacesContext.getViewRoot().setViewId(nc.getViewRootPath() + "/foo/foo.html");
        this.setFacesContext((MockFacesContext)new MockFacesContextImpl(){

            public UIViewRoot getViewRoot() {
                return null;
            }
        });
        LabelUtilTest.assertNull((Object)LabelUtil.getLabelValue((String)"aaa"));
        this.setFacesContext(orgFacesContext);
    }

    public void testGetLabelValue_viewRootPathIsInvalid() throws Exception {
        NamingConventionImpl nc = new NamingConventionImpl();
        nc.setViewRootPath("/view");
        nc.setViewExtension(".html");
        FacesConfigOptions.setDefaultSuffix((String)".html");
        this.getFacesContext().getViewRoot().setViewId("/foo/foo.html");
        LabelUtilTest.assertNull((Object)LabelUtil.getLabelValue((String)"/foo/bar.html"));
    }

    public void testGetPropertiesName() throws Exception {
        NamingConventionImpl nc = (NamingConventionImpl)this.getContainer().getComponent((Object)NamingConvention.class);
        nc.addRootPackageName(ClassUtil.getPackageName(((Object)((Object)this)).getClass()));
        this.register(FooPage.class, "foo_fooPage");
        LabelUtilTest.assertEquals((String)"javax.faces.internal.web.foo.label", (String)LabelUtil.getPropertiesName((NamingConvention)nc, (String)"foo_fooPage"));
    }

    public void testGetLabelKeySuffix() throws Exception {
        NamingConventionImpl nc = (NamingConventionImpl)this.getContainer().getComponent((Object)NamingConvention.class);
        nc.addRootPackageName(ClassUtil.getPackageName(((Object)((Object)this)).getClass()));
        this.register(FooPage.class, "foo_fooPage");
        FacesConfigOptions.setDefaultSuffix((String)".html");
        LabelUtilTest.assertEquals((String)"foo", (String)LabelUtil.getLabelKeySuffix((NamingConvention)nc, (String)"foo_fooPage"));
    }

    public void testGetDefaultApplicationPropertiesName() throws Exception {
        NamingConventionImpl nc = (NamingConventionImpl)this.getContainer().getComponent((Object)NamingConvention.class);
        nc.addRootPackageName(ClassUtil.getPackageName(((Object)((Object)this)).getClass()));
        this.register(FooPage.class, "foo_fooPage");
        LabelUtilTest.assertEquals((String)(ClassUtil.getPackageName(((Object)((Object)this)).getClass()) + ".web.label"), (String)LabelUtil.getDefaultApplicationPropertiesName((NamingConvention)nc, (String)"foo_fooPage"));
    }

    public void testGetDefaultApplicationPropertiesName_packageNameNull() throws Exception {
        NamingConventionImpl nc = (NamingConventionImpl)this.getContainer().getComponent((Object)NamingConvention.class);
        nc.addRootPackageName(ClassUtil.getPackageName(((Object)((Object)this)).getClass()));
        this.register(FooPage.class, "foo_fooPage");
        LabelUtilTest.assertNull((Object)LabelUtil.getDefaultApplicationPropertiesName((NamingConvention)nc, (String)"noSuchPackage_fooPage"));
    }
}

