/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.io.Serializable;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.internal.AttachedObjectStateWrapper;
import junit.framework.TestCase;
import org.seasar.teeda.core.mock.MockFacesContextImpl;

public class AttachedObjectStateWrapperTest
extends TestCase {
    public void testRestoreSerializable() {
        MockFacesContextImpl context = new MockFacesContextImpl();
        SerializableBean target = new SerializableBean();
        AttachedObjectStateWrapper wrapper = new AttachedObjectStateWrapper((FacesContext)context, (Object)target);
        AttachedObjectStateWrapperTest.assertEquals((Object)target, (Object)wrapper.restore((FacesContext)context));
    }

    public void testRestoreStateHolder() {
        MockFacesContextImpl context = new MockFacesContextImpl();
        StateHolderBean target = new StateHolderBean();
        target.setStr("a");
        AttachedObjectStateWrapper wrapper = new AttachedObjectStateWrapper((FacesContext)context, (Object)target);
        Object o = wrapper.restore((FacesContext)context);
        AttachedObjectStateWrapperTest.assertTrue((boolean)(o instanceof StateHolderBean));
        AttachedObjectStateWrapperTest.assertEquals((String)"a", (String)((StateHolderBean)o).getStr());
    }

    public void testRestoreStateHolder_restoredStateIsNull() throws Exception {
        MockFacesContextImpl context = new MockFacesContextImpl();
        StateHolderBean2 target = new StateHolderBean2();
        AttachedObjectStateWrapper wrapper = new AttachedObjectStateWrapper((FacesContext)context, (Object)target);
        Object o = wrapper.restore((FacesContext)context);
        AttachedObjectStateWrapperTest.assertNotNull((Object)o);
        AttachedObjectStateWrapperTest.assertTrue((boolean)(o instanceof StateHolderBean2));
    }

    private static class StateHolderBean2
    implements StateHolder {
        public boolean isTransient() {
            return false;
        }

        public void setTransient(boolean transientValue) {
        }

        public Object saveState(FacesContext context) {
            return null;
        }

        public void restoreState(FacesContext context, Object state) {
        }
    }

    private static class StateHolderBean
    implements StateHolder {
        private boolean transientValue_ = false;
        private String str_ = null;

        public boolean isTransient() {
            return this.transientValue_;
        }

        public void setTransient(boolean transientValue) {
            this.transientValue_ = transientValue;
        }

        public Object saveState(FacesContext context) {
            Object[] values = new Object[]{this.str_};
            return values;
        }

        public void restoreState(FacesContext context, Object state) {
            Object[] values = (Object[])state;
            this.str_ = (String)values[0];
        }

        public void setStr(String str) {
            this.str_ = str;
        }

        public String getStr() {
            return this.str_;
        }
    }

    private static class SerializableBean
    implements Serializable {
        private static final long serialVersionUID = 3257005453899544628L;
    }
}

