/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.AbstractConverterTestCase;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.NumberConverter;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockUIComponent;

public class NumberConverterTest
extends AbstractConverterTestCase {
    public void testConstants() throws Exception {
        NumberConverterTest.assertEquals((String)"javax.faces.Number", (String)"javax.faces.Number");
    }

    public void testGetAsObject_convertSuccess() throws Exception {
        NumberConverter converter = (NumberConverter)this.createConverter();
        converter.setType("number");
        Object o = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), "99.9");
        NumberConverterTest.assertNotNull((Object)o);
        NumberConverterTest.assertTrue((boolean)(o instanceof Number));
        Number n = (Number)o;
        NumberConverterTest.assertTrue((n.floatValue() == 99.9f ? 1 : 0) != 0);
    }

    public void testGetAsObject_convertFail() throws Exception {
        NumberConverter converter = (NumberConverter)this.createConverter();
        converter.setType("number");
        try {
            converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), "aaa");
            NumberConverterTest.fail();
        }
        catch (ConverterException expected) {
            NumberConverterTest.success();
        }
    }

    public void testGetAsString_convertSuccess() throws Exception {
        NumberConverter converter = (NumberConverter)this.createConverter();
        converter.setType("number");
        String s = converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), (Object)new Integer(123));
        NumberConverterTest.assertEquals((String)"123", (String)s);
    }

    public void testGetAsString_convertFail() throws Exception {
        NumberConverter converter = (NumberConverter)this.createConverter();
        converter.setType("number");
        try {
            converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), new ArrayList());
            NumberConverterTest.fail();
        }
        catch (ConverterException expected) {
            NumberConverterTest.success();
        }
    }

    public void testGetAsObjectWithCurrency() throws Exception {
        NumberConverter converter = (NumberConverter)this.createConverter();
        converter.setType("currency");
        converter.setPattern("#,##0.000");
        double amount = 500000.123;
        Object o = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), Double.toString(amount));
        NumberConverterTest.assertEquals((String)"500000.123", (String)o.toString());
    }

    public void testGetAsStringWithCurrency() throws Exception {
        NumberConverter converter = (NumberConverter)this.createConverter();
        converter.setType("currency");
        converter.setPattern("#,##0.000");
        double amount = 500000.123456;
        String s = converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), (Object)new Double(amount));
        System.out.println(s);
        NumberConverterTest.assertEquals((String)"500,000.123", (String)s);
    }

    public void testSaveAndRestore() throws Exception {
        NumberConverter converter = (NumberConverter)this.createConverter();
        converter.setType("currency");
        converter.setPattern("#,##0.000");
        MockFacesContext context = this.getFacesContext();
        Object saveState = converter.saveState((FacesContext)context);
        NumberConverter converter2 = (NumberConverter)this.createConverter();
        converter2.restoreState((FacesContext)context, saveState);
        NumberConverterTest.assertEquals((String)"currency", (String)converter.getType());
        NumberConverterTest.assertEquals((String)"#,##0.000", (String)converter.getPattern());
    }

    protected Converter createConverter() {
        return this.createNumberConverter();
    }

    protected NumberConverter createNumberConverter() {
        return new NumberConverter();
    }
}

