/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.AbstractConverterTestCase;
import javax.faces.convert.CharacterConverter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockFacesContextImpl;
import org.seasar.teeda.core.mock.MockUIComponent;

public class CharacterConverterTest
extends AbstractConverterTestCase {
    public void testGetAsObject_valueLengthIsBlank() throws Exception {
        Converter converter = this.createConverter();
        try {
            converter.getAsObject((FacesContext)new MockFacesContextImpl(), (UIComponent)new MockUIComponent(), "");
            CharacterConverterTest.fail();
        }
        catch (ConverterException e) {
            CharacterConverterTest.success();
        }
    }

    public void testGetAsObject_convertSuccess() {
        Converter converter = this.createConverter();
        MockUIComponent component = new MockUIComponent();
        MockFacesContext context = this.getFacesContext();
        String value = "abc";
        Object o = converter.getAsObject((FacesContext)context, (UIComponent)component, value);
        CharacterConverterTest.assertTrue((boolean)(o instanceof Character));
        Character c = (Character)o;
        CharacterConverterTest.assertEquals((char)value.charAt(0), (char)c.charValue());
    }

    public void testGetAsString_convertSuccess() {
        Converter converter = this.createConverter();
        MockUIComponent component = new MockUIComponent();
        MockFacesContext context = this.getFacesContext();
        String value = "abc";
        String str = converter.getAsString((FacesContext)context, (UIComponent)component, (Object)value);
        CharacterConverterTest.assertEquals((String)value, (String)str);
        Character ch = new Character('d');
        str = converter.getAsString((FacesContext)context, (UIComponent)component, (Object)ch);
        CharacterConverterTest.assertEquals((Object)ch, (Object)new Character(str.charAt(0)));
    }

    public void testGetAsString_convertFail() {
        Converter converter = this.createConverter();
        MockUIComponent component = new MockUIComponent();
        MockFacesContext context = this.getFacesContext();
        Integer i = new Integer(1);
        try {
            converter.getAsString((FacesContext)context, (UIComponent)component, (Object)i);
            CharacterConverterTest.fail();
        }
        catch (Exception e) {
            CharacterConverterTest.assertTrue((boolean)true);
        }
    }

    public void testConstants() throws Exception {
        CharacterConverterTest.assertEquals((String)"javax.faces.Character", (String)"javax.faces.Character");
    }

    protected Converter createConverter() {
        return this.createCharacterConverter();
    }

    protected CharacterConverter createCharacterConverter() {
        return new CharacterConverter();
    }
}

