/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.math.BigDecimal;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.AbstractConverterTestCase;
import javax.faces.convert.BigDecimalConverter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.seasar.teeda.core.mock.MockUIComponent;

public class BigDecimalConverterTest
extends AbstractConverterTestCase {
    public void testGetAsObject_convertSuccess() throws Exception {
        Converter converter = this.createConverter();
        String value = "123000000000";
        Object o = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), value);
        BigDecimalConverterTest.assertTrue((boolean)(o instanceof BigDecimal));
        BigDecimal b = (BigDecimal)o;
        BigDecimalConverterTest.assertEquals((long)Long.valueOf(value), (long)b.longValue());
    }

    public void testGetAsObject_convertFail() throws Exception {
        Converter converter = this.createConverter();
        String value = "aaa";
        try {
            converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), value);
            BigDecimalConverterTest.fail();
        }
        catch (ConverterException e) {
            BigDecimalConverterTest.success();
        }
    }

    public void testGetAsString_convertSuccess() throws Exception {
        Converter converter = this.createConverter();
        BigDecimal b = new BigDecimal("123.456");
        String str = converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), (Object)b);
        BigDecimalConverterTest.assertEquals((String)b.toString(), (String)str);
    }

    public void testGetAsString_convertFail() throws Exception {
        Converter converter = this.createConverter();
        Integer i = new Integer(1);
        try {
            converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), (Object)i);
            BigDecimalConverterTest.fail();
        }
        catch (ConverterException e) {
            BigDecimalConverterTest.assertTrue((boolean)true);
        }
    }

    public void testGetAsObject_convertwithDelimeter() throws Exception {
        Converter converter = this.createConverter();
        String value = "123,000,000,000";
        this.getFacesContext().getViewRoot().setLocale(Locale.JAPAN);
        Object o = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), value);
        BigDecimalConverterTest.assertTrue((boolean)(o instanceof BigDecimal));
        BigDecimal b = (BigDecimal)o;
        BigDecimalConverterTest.assertEquals((long)Long.valueOf("123000000000"), (long)b.longValue());
    }

    public void testConstants() throws Exception {
        BigDecimalConverterTest.assertEquals((String)"javax.faces.BigDecimal", (String)"javax.faces.BigDecimal");
    }

    protected Converter createConverter() {
        return this.createBigDecimalConverter();
    }

    private BigDecimalConverter createBigDecimalConverter() {
        return new BigDecimalConverter();
    }
}

