/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.HashMap;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutputTeedaTest;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.internal.ConverterResource;
import javax.faces.internal.ValidatorResource;
import javax.faces.validator.DoubleRangeValidator;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockValueBinding;

public class UIInputTeedaTest
extends UIOutputTeedaTest {
    public void tearDown() {
        ConverterResource.removeAll();
        ValidatorResource.removeAll();
    }

    public void testSaveAndRestoreState() throws Exception {
        super.testSaveAndRestoreState();
        UIInput input1 = this.createUIInput();
        LengthValidator lengthValidator = new LengthValidator();
        lengthValidator.setMaximum(33);
        input1.addValidator((Validator)lengthValidator);
        DoubleRangeValidator doubleRangeValidator = new DoubleRangeValidator();
        doubleRangeValidator.setMinimum(10.0);
        doubleRangeValidator.setMaximum(21.0);
        input1.addValidator((Validator)doubleRangeValidator);
        MockFacesContext context = this.getFacesContext();
        Object decoded = this.serializeAndDeserialize(input1.saveState((FacesContext)context));
        UIInput input2 = this.createUIInput();
        input2.restoreState((FacesContext)context, decoded);
        Validator[] validators = input2.getValidators();
        UIInputTeedaTest.assertEquals((int)2, (int)validators.length);
        LengthValidator lengthValidator2 = (LengthValidator)validators[0];
        UIInputTeedaTest.assertEquals((int)33, (int)lengthValidator2.getMaximum());
        DoubleRangeValidator doubleRangeValidator2 = (DoubleRangeValidator)validators[1];
        UIInputTeedaTest.assertEquals((double)10.0, (double)doubleRangeValidator2.getMinimum(), (double)0.0);
        UIInputTeedaTest.assertEquals((double)21.0, (double)doubleRangeValidator2.getMaximum(), (double)0.0);
        UIInputTeedaTest.assertEquals((Object)input1.getValue(), (Object)input2.getValue());
    }

    public final void testHandleValidationException() throws Exception {
        UIInput input = new UIInput();
        input.setId("id");
        ValidatorException ve = new ValidatorException(new FacesMessage("aaa"));
        MockFacesContext context = this.getFacesContext();
        UIViewRoot root = new UIViewRoot();
        root.setRenderKitId("HTML_BASIC");
        context.setViewRoot(root);
        input.handleValidationException((FacesContext)context, ve);
        Iterator itr = context.getMessages();
        Object o = itr.next();
        UIInputTeedaTest.assertTrue((boolean)(o instanceof FacesMessage));
        FacesMessage message = (FacesMessage)o;
        UIInputTeedaTest.assertEquals((String)"aaa", (String)message.getSummary());
    }

    public void testValidateValue() throws Exception {
        UIInput input = new UIInput();
        input.setValid(true);
        input.setRequired(true);
        MockValueBinding vb = new MockValueBinding();
        vb.setExpressionString("#{a.name}");
        input.setValueBinding("value", (ValueBinding)vb);
        this.register(LengthValidator.class, "lengthValidator");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("maximum", new Integer(5));
        map.put("minimum", new Integer(2));
        ValidatorResource.addValidator((String)"#{a.name}", (String)"lengthValidator", map);
        input.validateValue((FacesContext)this.getFacesContext(), (Object)new Integer(6));
        Iterator itr = this.getFacesContext().getMessages();
        Object o = itr.next();
        UIInputTeedaTest.assertTrue((boolean)(o instanceof FacesMessage));
        FacesMessage message = (FacesMessage)o;
        UIInputTeedaTest.assertNotNull((Object)message);
        UIInputTeedaTest.assertEquals((Object)FacesMessage.SEVERITY_ERROR, (Object)message.getSeverity());
    }

    public void testValidate() throws Exception {
        MockFacesContext context = this.getFacesContext();
        UIInput input = this.createUIInput();
        input.setId("aaa");
        input.getAttributes().put("label", "hoge");
        input.setSubmittedValue((Object)"");
        this.register(new Converter(){

            public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
                return "";
            }

            public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
                return "";
            }
        }, "converter");
        ConverterResource.addConverter((String)"#{hoge}", (String)"converter");
        input.setValueBinding("value", (ValueBinding)new MockValueBinding(){

            public String getExpressionString() {
                return "#{hoge}";
            }
        });
        input.setValid(true);
        input.setRequired(true);
        input.validate((FacesContext)context);
        Iterator messages = context.getMessages();
        UIInputTeedaTest.assertTrue((messages != null ? 1 : 0) != 0);
        FacesMessage next = (FacesMessage)messages.next();
        UIInputTeedaTest.assertTrue((next != null ? 1 : 0) != 0);
        String detail = next.getDetail();
        UIInputTeedaTest.assertTrue((detail.indexOf("hoge") >= 0 ? 1 : 0) != 0);
    }

    private UIInput createUIInput() {
        return (UIInput)this.createUIComponent();
    }

    protected UIComponent createUIComponent() {
        return new UIInput();
    }
}

