/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlOutputText;
import org.seasar.teeda.core.render.html.HtmlOutputTextRenderer;
import org.seasar.teeda.core.render.html.HtmlPanelGridRenderer;

public class HtmlPanelGridRendererTest
extends RendererTest {
    private HtmlPanelGridRenderer renderer;
    private MockHtmlPanelGrid htmlPanelGrid;
    private HtmlOutputTextRenderer textRenderer;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlPanelGridRenderer();
        this.textRenderer = new HtmlOutputTextRenderer();
        this.htmlPanelGrid = new MockHtmlPanelGrid();
        this.htmlPanelGrid.setRenderer((Renderer)this.renderer);
    }

    public void testEncodeBegin_NoValue() throws Exception {
        this.renderer.encodeBegin((FacesContext)this.getFacesContext(), (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"<table", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlPanelGrid.setRendered(false);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncodeBegin_Id() throws Exception {
        this.htmlPanelGrid.setId("aaa");
        this.renderer.encodeBegin((FacesContext)this.getFacesContext(), (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"<table id=\"aaa\"", (String)this.getResponseText());
    }

    public void testEncodeBegin_WithUnknownAttribute1() throws Exception {
        this.htmlPanelGrid.getAttributes().put("abc", "ABC");
        this.renderer.encodeBegin((FacesContext)this.getFacesContext(), (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"<table abc=\"ABC\"", (String)this.getResponseText());
    }

    public void testEncodeBegin_WithUnknownAttribute2() throws Exception {
        this.htmlPanelGrid.getAttributes().put("a.bc", "ABC");
        this.renderer.encodeBegin((FacesContext)this.getFacesContext(), (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"<table", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableStyle() throws Exception {
        this.htmlPanelGrid.setStyle("a");
        this.htmlPanelGrid.setStyleClass("b");
        this.renderer.encodeBegin((FacesContext)this.getFacesContext(), (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"<table class=\"b\" style=\"a\"", (String)this.getResponseText());
    }

    public void testEncode_NoValue() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"<table><tbody></tbody></table>", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableHeaderFacet() throws Exception {
        MockHtmlOutputText facet = new MockHtmlOutputText();
        facet.setRenderer((Renderer)this.textRenderer);
        facet.setValue("a");
        this.htmlPanelGrid.getFacets().put("header", facet);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"<table><thead><tr><th scope=\"colgroup\">a</th></tr></thead>", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableHeaderStyle() throws Exception {
        MockHtmlOutputText facet = new MockHtmlOutputText();
        facet.setRenderer((Renderer)this.textRenderer);
        facet.setValue("aa");
        this.htmlPanelGrid.getFacets().put("header", facet);
        this.htmlPanelGrid.setHeaderClass("bb");
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"<table><thead><tr><th scope=\"colgroup\" class=\"bb\">aa</th></tr></thead>", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableHeaderColspan() throws Exception {
        MockHtmlOutputText facet = new MockHtmlOutputText();
        facet.setRenderer((Renderer)this.textRenderer);
        facet.setValue("a");
        this.htmlPanelGrid.getFacets().put("header", facet);
        this.htmlPanelGrid.setColumns(4);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"<table><thead><tr><th colspan=\"4\" scope=\"colgroup\">a</th></tr></thead>", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableHeaderFacetRenderFalse() throws Exception {
        MockHtmlOutputText facet = new MockHtmlOutputText();
        facet.setRenderer((Renderer)this.textRenderer);
        facet.setValue("a");
        facet.setRendered(false);
        this.htmlPanelGrid.getFacets().put("header", facet);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"<table", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableFooterFacet() throws Exception {
        MockHtmlOutputText facet = new MockHtmlOutputText();
        facet.setRenderer((Renderer)this.textRenderer);
        facet.setValue("a");
        this.htmlPanelGrid.getFacets().put("footer", facet);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"<table><tfoot><tr><td>a</td></tr></tfoot>", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableFooterStyle() throws Exception {
        MockHtmlOutputText facet = new MockHtmlOutputText();
        facet.setRenderer((Renderer)this.textRenderer);
        facet.setValue("aa");
        this.htmlPanelGrid.getFacets().put("footer", facet);
        this.htmlPanelGrid.setFooterClass("bb");
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"<table><tfoot><tr><td class=\"bb\">aa</td></tr></tfoot>", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableFooterColspan() throws Exception {
        MockHtmlOutputText facet = new MockHtmlOutputText();
        facet.setRenderer((Renderer)this.textRenderer);
        facet.setValue("a");
        this.htmlPanelGrid.getFacets().put("footer", facet);
        this.htmlPanelGrid.setColumns(4);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"<table><tfoot><tr><td colspan=\"4\">a</td></tr></tfoot>", (String)this.getResponseText());
    }

    public void testEncodeBegin_TableFooterFacetRenderFalse() throws Exception {
        MockHtmlOutputText facet = new MockHtmlOutputText();
        facet.setRenderer((Renderer)this.textRenderer);
        facet.setValue("a");
        facet.setRendered(false);
        this.htmlPanelGrid.getFacets().put("footer", facet);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"<table", (String)this.getResponseText());
    }

    public void testEncodeChildren() throws Exception {
        MockHtmlOutputText child = new MockHtmlOutputText();
        child.setRenderer((Renderer)this.textRenderer);
        child.setValue("Z");
        this.htmlPanelGrid.getChildren().add(child);
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeChildren((FacesContext)context, (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"<tbody><tr><td>Z</td></tr></tbody>", (String)this.getResponseText());
    }

    public void testEncodeChildren_RowAndColumnStyle() throws Exception {
        this.htmlPanelGrid.setColumnClasses("c1, c2, c3");
        this.htmlPanelGrid.setRowClasses("r1a r1b, r2");
        this.htmlPanelGrid.setColumns(7);
        for (int i = 0; i < 15; ++i) {
            MockHtmlOutputText child = new MockHtmlOutputText();
            child.setRenderer((Renderer)this.textRenderer);
            char c = (char)(65 + i);
            child.setValue(String.valueOf(c));
            this.htmlPanelGrid.getChildren().add(child);
        }
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeChildren((FacesContext)context, (UIComponent)this.htmlPanelGrid);
        HtmlPanelGridRendererTest.assertEquals((String)"<tbody><tr class=\"r1a r1b\"><td class=\"c1\">A</td><td class=\"c2\">B</td><td class=\"c3\">C</td><td class=\"c1\">D</td><td class=\"c2\">E</td><td class=\"c3\">F</td><td class=\"c1\">G</td></tr><tr class=\"r2\"><td class=\"c1\">H</td><td class=\"c2\">I</td><td class=\"c3\">J</td><td class=\"c1\">K</td><td class=\"c2\">L</td><td class=\"c3\">M</td><td class=\"c1\">N</td></tr><tr class=\"r1a r1b\"><td class=\"c1\">O</td></tr></tbody>", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlPanelGrid.setBgcolor("a");
        this.htmlPanelGrid.setBorder(3);
        this.htmlPanelGrid.setCellpadding("c");
        this.htmlPanelGrid.setCellspacing("d");
        this.htmlPanelGrid.setColumnClasses("e1, e2");
        this.htmlPanelGrid.setDir("f");
        this.htmlPanelGrid.setFooterClass("g");
        this.htmlPanelGrid.setFrame("h");
        this.htmlPanelGrid.setHeaderClass("i");
        this.htmlPanelGrid.setLang("j");
        this.htmlPanelGrid.setOnclick("k");
        this.htmlPanelGrid.setOndblclick("l");
        this.htmlPanelGrid.setOnkeydown("m");
        this.htmlPanelGrid.setOnkeypress("n");
        this.htmlPanelGrid.setOnkeyup("o");
        this.htmlPanelGrid.setOnmousedown("p");
        this.htmlPanelGrid.setOnmousemove("q");
        this.htmlPanelGrid.setOnmouseout("r");
        this.htmlPanelGrid.setOnmouseover("s");
        this.htmlPanelGrid.setOnmouseup("t");
        this.htmlPanelGrid.setRowClasses("u1, u2");
        this.htmlPanelGrid.setRules("v");
        this.htmlPanelGrid.setStyle("w");
        this.htmlPanelGrid.setStyleClass("x");
        this.htmlPanelGrid.setSummary("y");
        this.htmlPanelGrid.setTitle("z");
        this.htmlPanelGrid.setWidth("1");
        this.htmlPanelGrid.setId("A");
        this.htmlPanelGrid.setColumnClasses("c1, c2");
        this.htmlPanelGrid.setRowClasses("r1, r2,r3");
        this.htmlPanelGrid.setColumns(3);
        MockHtmlOutputText header = new MockHtmlOutputText();
        header.setRenderer((Renderer)this.textRenderer);
        header.setValue("tableHeader");
        this.htmlPanelGrid.getFacets().put("header", header);
        MockHtmlOutputText footer = new MockHtmlOutputText();
        footer.setRenderer((Renderer)this.textRenderer);
        footer.setValue("tableFooter");
        this.htmlPanelGrid.getFacets().put("footer", footer);
        for (int i = 10; i < 24; ++i) {
            MockHtmlOutputText child = new MockHtmlOutputText();
            child.setRenderer((Renderer)this.textRenderer);
            child.setValue(String.valueOf(i));
            this.htmlPanelGrid.getChildren().add(child);
        }
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlPanelGrid);
        Diff diff = new Diff("<table id=\"A\" bgcolor=\"a\" border=\"3\" cellpadding=\"c\" cellspacing=\"d\" dir=\"f\" frame=\"h\" lang=\"j\" onclick=\"k\" ondblclick=\"l\" onkeydown=\"m\" onkeypress=\"n\" onkeyup=\"o\" onmousedown=\"p\" onmousemove=\"q\" onmouseout=\"r\" onmouseover=\"s\" onmouseup=\"t\" rules=\"v\" style=\"w\" class=\"x\" summary=\"y\" title=\"z\" width=\"1\"><thead><tr><th class=\"i\" colspan=\"3\" scope=\"colgroup\">tableHeader</th></tr></thead><tfoot><tr><td class=\"g\" colspan=\"3\">tableFooter</td></tr></tfoot><tbody><tr class=\"r1\"><td class=\"c1\">10</td><td class=\"c2\">11</td><td class=\"c1\">12</td></tr><tr class=\"r2\"><td class=\"c1\">13</td><td class=\"c2\">14</td><td class=\"c1\">15</td></tr><tr class=\"r3\"><td class=\"c1\">16</td><td class=\"c2\">17</td><td class=\"c1\">18</td></tr><tr class=\"r1\"><td class=\"c1\">19</td><td class=\"c2\">20</td><td class=\"c1\">21</td></tr><tr class=\"r2\"><td class=\"c1\">22</td><td class=\"c2\">23</td></tr></tbody></table>", this.getResponseText());
        HtmlPanelGridRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testGetRendersChildren() throws Exception {
        HtmlPanelGridRendererTest.assertEquals((boolean)true, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlPanelGridRenderer createHtmlPanelGridRenderer() {
        return (HtmlPanelGridRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlPanelGridRenderer renderer = new HtmlPanelGridRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }

    private static class MockHtmlPanelGrid
    extends HtmlPanelGrid {
        private Renderer renderer_ = null;

        private MockHtmlPanelGrid() {
        }

        public void setRenderer(Renderer renderer) {
            this.renderer_ = renderer;
        }

        protected Renderer getRenderer(FacesContext context) {
            if (this.renderer_ != null) {
                return this.renderer_;
            }
            return super.getRenderer(context);
        }
    }
}

