/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.util.SortedMap;
import java.util.TreeMap;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.faces.model.ResultDataModel;
import javax.servlet.jsp.jstl.sql.Result;
import junit.framework.TestCase;
import org.seasar.teeda.core.mock.MockDataModelListener;

public class ResultDataModelTest
extends TestCase {
    public void testIsRowAvailable() throws Exception {
        Object[] obj = new Object[]{"a", "b"};
        MockResult result = new MockResult(obj);
        ResultDataModel model = new ResultDataModel((Result)result);
        ResultDataModelTest.assertTrue((boolean)model.isRowAvailable());
        model.setRowIndex(1);
        ResultDataModelTest.assertTrue((boolean)model.isRowAvailable());
        model.setRowIndex(obj.length + 1);
        ResultDataModelTest.assertFalse((boolean)model.isRowAvailable());
        ResultDataModel model2 = new ResultDataModel();
        ResultDataModelTest.assertFalse((boolean)model2.isRowAvailable());
    }

    public void testGetRowCount() throws Exception {
        Object[] obj = new Object[]{"a"};
        MockResult result = new MockResult(obj);
        ResultDataModel model = new ResultDataModel((Result)result);
        ResultDataModelTest.assertEquals((int)1, (int)model.getRowCount());
        ResultDataModel model2 = new ResultDataModel();
        ResultDataModelTest.assertEquals((int)-1, (int)model2.getRowCount());
    }

    public void testGetRowData() throws Exception {
        Object[] obj = new Object[]{"a", "b"};
        MockResult result = new MockResult(obj);
        ResultDataModel model = new ResultDataModel((Result)result);
        Object o = model.getRowData();
        ResultDataModelTest.assertTrue((boolean)(o instanceof SortedMap));
        ResultDataModelTest.assertEquals((Object)"a", ((SortedMap)o).get("a"));
        model.setRowIndex(1);
        o = model.getRowData();
        ResultDataModelTest.assertTrue((boolean)(o instanceof SortedMap));
        ResultDataModelTest.assertEquals((Object)"b", ((SortedMap)o).get("b"));
        ResultDataModel model2 = new ResultDataModel();
        ResultDataModelTest.assertNull((Object)model2.getRowData());
        Object[] target = new Object[]{"A"};
        MockResult result3 = new MockResult(target);
        ResultDataModel model3 = new ResultDataModel((Result)result3);
        model3.setRowIndex(target.length + 1);
        try {
            model3.getRowData();
            ResultDataModelTest.fail();
        }
        catch (IllegalArgumentException e) {
            ResultDataModelTest.assertTrue((boolean)true);
        }
    }

    public void testGetRowIndex() throws Exception {
        Object[] obj = new Object[]{"a", "b"};
        MockResult result = new MockResult(obj);
        ResultDataModel model = new ResultDataModel((Result)result);
        ResultDataModelTest.assertEquals((int)0, (int)model.getRowIndex());
        model.setRowIndex(1);
        ResultDataModelTest.assertEquals((int)1, (int)model.getRowIndex());
        ResultDataModel model2 = new ResultDataModel();
        ResultDataModelTest.assertEquals((int)-1, (int)model2.getRowIndex());
    }

    public void testSetRowIndex() throws Exception {
        Object[] args = new Object[]{"1", "2"};
        MockResult result = new MockResult(args);
        ResultDataModel model = new ResultDataModel((Result)result);
        MockDataModelListener listener = new MockDataModelListener();
        model.addDataModelListener((DataModelListener)listener);
        int index = 1;
        model.setRowIndex(index);
        DataModelEvent event = listener.getDataModelEvent();
        Object o = event.getRowData();
        ResultDataModelTest.assertTrue((boolean)(o instanceof SortedMap));
        SortedMap map = (SortedMap)o;
        String target = (String)args[index];
        ResultDataModelTest.assertEquals((Object)target, map.get(target));
        try {
            model.setRowIndex(-2);
            ResultDataModelTest.fail();
        }
        catch (IllegalArgumentException e) {
            ResultDataModelTest.assertTrue((boolean)true);
        }
        ResultDataModel model2 = new ResultDataModel();
        MockDataModelListener listener2 = new MockDataModelListener();
        model2.addDataModelListener((DataModelListener)listener2);
        model2.setRowIndex(1);
        ResultDataModelTest.assertNull((Object)listener2.getDataModelEvent());
        Object[] args3 = new Object[]{"b", "c", "d"};
        MockResult result3 = new MockResult(args3);
        ResultDataModel model3 = new ResultDataModel((Result)result3);
        MockDataModelListener listener3 = new MockDataModelListener();
        model3.addDataModelListener((DataModelListener)listener3);
        model3.setRowIndex(args3.length + 1);
        DataModelEvent event3 = listener3.getDataModelEvent();
        ResultDataModelTest.assertNull((Object)event3.getRowData());
        ResultDataModelTest.assertEquals((int)(args3.length + 1), (int)event3.getRowIndex());
    }

    public void testGetWrappedData() throws Exception {
        Object[] args = new Object[]{"a"};
        MockResult result = new MockResult(args);
        ResultDataModel model = new ResultDataModel((Result)result);
        Object o = model.getWrappedData();
        ResultDataModelTest.assertNotNull((Object)o);
        ResultDataModelTest.assertTrue((boolean)(o instanceof Result));
        ResultDataModelTest.assertEquals((Object)result, (Object)o);
    }

    public void testSetWrappedData() throws Exception {
        ResultDataModel model = new ResultDataModel();
        ResultDataModelTest.assertNull((Object)model.getWrappedData());
        Object[] args = new Object[]{new Integer(1), new Integer(2)};
        MockResult result = new MockResult(args);
        model.setWrappedData((Object)result);
        Object o = model.getWrappedData();
        ResultDataModelTest.assertNotNull((Object)o);
        ResultDataModelTest.assertTrue((boolean)(o instanceof Result));
        ResultDataModelTest.assertEquals((Object)result, (Object)o);
    }

    private static class MockResult
    implements Result {
        private Object[] obj_ = null;

        public MockResult(Object[] obj) {
            this.obj_ = obj;
        }

        public SortedMap[] getRows() {
            TreeMap[] treeMaps = new TreeMap[this.obj_.length];
            for (int i = 0; i < this.obj_.length; ++i) {
                treeMaps[i] = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                treeMaps[i].put(this.obj_[i], this.obj_[i]);
            }
            return treeMaps;
        }

        public Object[][] getRowsByIndex() {
            throw new UnsupportedOperationException();
        }

        public String[] getColumnNames() {
            throw new UnsupportedOperationException();
        }

        public int getRowCount() {
            throw new UnsupportedOperationException();
        }

        public boolean isLimitedByMaxRows() {
            throw new UnsupportedOperationException();
        }
    }
}

