/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.internal.SelectItemsIterator;
import javax.faces.model.SelectItem;
import junit.framework.TestCase;
import junitx.framework.ObjectAssert;
import org.seasar.teeda.core.mock.MockUIComponent;
import org.seasar.teeda.core.unit.ExceptionAssert;

public class SelectItemsIteratorTest
extends TestCase {
    public void testUISelectItem() throws Exception {
        UISelectMany component = new UISelectMany();
        UISelectItem uiSelectItem = new UISelectItem();
        uiSelectItem.setItemValue((Object)"a");
        uiSelectItem.setItemLabel("b");
        uiSelectItem.setItemDescription("c");
        component.getChildren().add(uiSelectItem);
        uiSelectItem = new UISelectItem();
        uiSelectItem.setItemValue((Object)"d");
        uiSelectItem.setItemLabel("e");
        uiSelectItem.setItemDescription("f");
        component.getChildren().add(uiSelectItem);
        SelectItemsIterator it = new SelectItemsIterator((UIComponent)component);
        SelectItemsIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        SelectItem item = (SelectItem)it.next();
        SelectItemsIteratorTest.assertEquals((Object)"a", (Object)item.getValue());
        SelectItemsIteratorTest.assertEquals((String)"b", (String)item.getLabel());
        SelectItemsIteratorTest.assertEquals((String)"c", (String)item.getDescription());
        SelectItemsIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        item = (SelectItem)it.next();
        SelectItemsIteratorTest.assertEquals((Object)"d", (Object)item.getValue());
        SelectItemsIteratorTest.assertEquals((String)"e", (String)item.getLabel());
        SelectItemsIteratorTest.assertEquals((String)"f", (String)item.getDescription());
        SelectItemsIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testEmptyUISelectItems() throws Exception {
        UISelectMany component = new UISelectMany();
        component.getChildren().add(new UISelectItems());
        SelectItemsIterator it = new SelectItemsIterator((UIComponent)component);
        SelectItemsIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testUISelectItem_SelectItem() throws Exception {
        UISelectMany component = new UISelectMany();
        SelectItem selectItem = new SelectItem();
        selectItem.setValue((Object)"val");
        selectItem.setLabel("lab");
        selectItem.setDescription("desc");
        UISelectItem ui = new UISelectItem();
        ui.setValue((Object)selectItem);
        component.getChildren().add(ui);
        SelectItemsIterator it = new SelectItemsIterator((UIComponent)component);
        SelectItemsIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        SelectItem item = (SelectItem)it.next();
        SelectItemsIteratorTest.assertEquals((Object)"val", (Object)item.getValue());
        SelectItemsIteratorTest.assertEquals((String)"lab", (String)item.getLabel());
        SelectItemsIteratorTest.assertEquals((String)"desc", (String)item.getDescription());
        SelectItemsIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testUISelectItems_SelectItem() throws Exception {
        UISelectMany component = new UISelectMany();
        SelectItem selectItem = new SelectItem();
        selectItem.setValue((Object)"val");
        selectItem.setLabel("lab");
        selectItem.setDescription("desc");
        UISelectItems ui = new UISelectItems();
        ui.setValue((Object)selectItem);
        component.getChildren().add(ui);
        SelectItemsIterator it = new SelectItemsIterator((UIComponent)component);
        SelectItemsIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        SelectItem item = (SelectItem)it.next();
        SelectItemsIteratorTest.assertEquals((Object)"val", (Object)item.getValue());
        SelectItemsIteratorTest.assertEquals((String)"lab", (String)item.getLabel());
        SelectItemsIteratorTest.assertEquals((String)"desc", (String)item.getDescription());
        SelectItemsIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testUISelectItems_SelectItemArray() throws Exception {
        UISelectMany component = new UISelectMany();
        UISelectItems ui = new UISelectItems();
        SelectItem item1 = new SelectItem((Object)"v1", "l1", "d1");
        SelectItem item2 = new SelectItem((Object)"v2", "l2", "d2");
        ui.setValue((Object)new SelectItem[]{item1, item2});
        component.getChildren().add(ui);
        SelectItemsIterator it = new SelectItemsIterator((UIComponent)component);
        SelectItemsIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        SelectItem item = (SelectItem)it.next();
        SelectItemsIteratorTest.assertEquals((Object)"v1", (Object)item.getValue());
        SelectItemsIteratorTest.assertEquals((String)"l1", (String)item.getLabel());
        SelectItemsIteratorTest.assertEquals((String)"d1", (String)item.getDescription());
        SelectItemsIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        item = (SelectItem)it.next();
        SelectItemsIteratorTest.assertEquals((Object)"v2", (Object)item.getValue());
        SelectItemsIteratorTest.assertEquals((String)"l2", (String)item.getLabel());
        SelectItemsIteratorTest.assertEquals((String)"d2", (String)item.getDescription());
        SelectItemsIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testUISelectItems_SelectItemCollection() throws Exception {
        UISelectMany component = new UISelectMany();
        UISelectItems uiSelectItems = new UISelectItems();
        ArrayList<SelectItem> l = new ArrayList<SelectItem>();
        l.add(new SelectItem((Object)"v1", "l1", "d1"));
        l.add(new SelectItem((Object)"v2", "l2", "d2"));
        l.add(new SelectItem((Object)"v3", "l3", "d3"));
        uiSelectItems.setValue(l);
        component.getChildren().add(uiSelectItems);
        SelectItemsIterator it = new SelectItemsIterator((UIComponent)component);
        SelectItemsIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        SelectItem item = (SelectItem)it.next();
        SelectItemsIteratorTest.assertEquals((Object)"v1", (Object)item.getValue());
        SelectItemsIteratorTest.assertEquals((String)"l1", (String)item.getLabel());
        SelectItemsIteratorTest.assertEquals((String)"d1", (String)item.getDescription());
        SelectItemsIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        item = (SelectItem)it.next();
        SelectItemsIteratorTest.assertEquals((Object)"v2", (Object)item.getValue());
        SelectItemsIteratorTest.assertEquals((String)"l2", (String)item.getLabel());
        SelectItemsIteratorTest.assertEquals((String)"d2", (String)item.getDescription());
        SelectItemsIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        item = (SelectItem)it.next();
        SelectItemsIteratorTest.assertEquals((Object)"v3", (Object)item.getValue());
        SelectItemsIteratorTest.assertEquals((String)"l3", (String)item.getLabel());
        SelectItemsIteratorTest.assertEquals((String)"d3", (String)item.getDescription());
        SelectItemsIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testUISelectItems_SelectItemMap() throws Exception {
        UISelectMany component = new UISelectMany();
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("l1", "v1");
        m.put("l2", "v2");
        UISelectItems ui = new UISelectItems();
        ui.setValue(m);
        component.getChildren().add(ui);
        SelectItemsIterator it = new SelectItemsIterator((UIComponent)component);
        SelectItemsIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        SelectItem item = (SelectItem)it.next();
        SelectItemsIteratorTest.assertEquals((Object)"v1", (Object)item.getValue());
        SelectItemsIteratorTest.assertEquals((String)"l1", (String)item.getLabel());
        SelectItemsIteratorTest.assertEquals(null, (String)item.getDescription());
        SelectItemsIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        item = (SelectItem)it.next();
        SelectItemsIteratorTest.assertEquals((Object)"v2", (Object)item.getValue());
        SelectItemsIteratorTest.assertEquals((String)"l2", (String)item.getLabel());
        SelectItemsIteratorTest.assertEquals(null, (String)item.getDescription());
        SelectItemsIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testChildrenAreNotUISelectItemOrUISelectItems() throws Exception {
        UISelectMany component = new UISelectMany();
        MockUIComponent invalidChild = new MockUIComponent();
        ObjectAssert.assertNotInstanceOf((Class)UISelectItem.class, (Object)invalidChild);
        ObjectAssert.assertNotInstanceOf((Class)UISelectItems.class, (Object)invalidChild);
        component.getChildren().add(invalidChild);
        SelectItemsIterator it = new SelectItemsIterator((UIComponent)component);
        SelectItemsIteratorTest.assertEquals((String)"only valid children are UISelectItem or UISelectItems", (boolean)false, (boolean)it.hasNext());
    }

    public void testIgnoreInvalidChildren() throws Exception {
        UISelectMany component = new UISelectMany();
        MockUIComponent invalidChild = new MockUIComponent();
        ObjectAssert.assertNotInstanceOf((Class)UISelectItem.class, (Object)invalidChild);
        ObjectAssert.assertNotInstanceOf((Class)UISelectItems.class, (Object)invalidChild);
        component.getChildren().add(invalidChild);
        UISelectItems ui = new UISelectItems();
        SelectItem item1 = new SelectItem((Object)"v1", "l1", "d1");
        SelectItem item2 = new SelectItem((Object)"v2", "l2", "d2");
        ui.setValue((Object)new SelectItem[]{item1, item2});
        component.getChildren().add(ui);
        SelectItemsIterator it = new SelectItemsIterator((UIComponent)component);
        SelectItemsIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        it.next();
        SelectItemsIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        it.next();
        SelectItemsIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testRemove() throws Exception {
        SelectItemsIterator it = new SelectItemsIterator((UIComponent)new MockUIComponent());
        try {
            it.remove();
        }
        catch (UnsupportedOperationException uoe) {
            ExceptionAssert.assertMessageExist(uoe);
        }
    }

    public void testNextThrowsNoSuchElementException() throws Exception {
        UISelectMany component = new UISelectMany();
        UISelectItem uiSelectItem = new UISelectItem();
        uiSelectItem.setItemValue((Object)"a");
        uiSelectItem.setItemLabel("b");
        component.getChildren().add(uiSelectItem);
        uiSelectItem = new UISelectItem();
        uiSelectItem.setItemValue((Object)"a");
        uiSelectItem.setItemLabel("b");
        component.getChildren().add(uiSelectItem);
        SelectItemsIterator it = new SelectItemsIterator((UIComponent)component);
        it.next();
        it.next();
        try {
            it.next();
            SelectItemsIteratorTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

